<?php $__env->startSection('page_title', 'Edit Student'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Edit Student</h3>
                <div>
                    <a href="<?php echo e(route('bss.students.index')); ?>" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('bss.students.update',$bssStudent->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="card-body">
                    <div class="row">
                        <!-- Student Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="mb-1">Student Name</label>
                                <input type="text" name="name"
                                    class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="name"
                                    placeholder="Enter Student Name" value="<?php echo e(old('name',$bssStudent->name)); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Gender -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="gender" class="mb-1">Gender</label>
                                <select name="gender" id="gender"
                                    class="form-control <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="" disabled selected>Select Gender</option>
                                    <option value="Male" <?php echo e(old('gender',$bssStudent->gender) == 'Male' ? 'selected' : ''); ?>>Male</option>
                                    <option value="Female" <?php echo e(old('gender',$bssStudent->gender) == 'Female' ? 'selected' : ''); ?>>Female</option>
                                    <option value="Other" <?php echo e(old('gender',$bssStudent->gender) == 'Other' ? 'selected' : ''); ?>>Other</option>
                                </select>
                                <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Class -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="class" class="mb-1">Class</label>
                                <select name="class" id="class"
                                    class="form-control <?php $__errorArgs = ['class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="" disabled selected>Select Class</option>
                                    <option value="Class 1" <?php echo e(old('class',$bssStudent->class) == 'Class 1' ? 'selected' : ''); ?>>Class 1
                                    </option>
                                    <option value="Class 2" <?php echo e(old('class',$bssStudent->class) == 'Class 2' ? 'selected' : ''); ?>>Class 2
                                    </option>
                                    <option value="Class 3" <?php echo e(old('class',$bssStudent->class) == 'Class 3' ? 'selected' : ''); ?>>Class 3
                                    </option>
                                </select>
                                <?php $__errorArgs = ['class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Category -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category" class="mb-1">Category</label>
                                <select name="category" id="category"
                                    class="form-control <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="" disabled selected>Select Category</option>
                                    <option value="General" <?php echo e(old('category') == 'General' ? 'selected' : ''); ?>>General
                                    </option>
                                    <option value="OBC" <?php echo e(old('category',$bssStudent->category) == 'OBC' ? 'selected' : ''); ?>>OBC</option>
                                    <option value="SC" <?php echo e(old('category',$bssStudent->category) == 'SC' ? 'selected' : ''); ?>>SC</option>
                                    <option value="ST" <?php echo e(old('category',$bssStudent->category) == 'ST' ? 'selected' : ''); ?>>ST</option>
                                </select>
                                <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Mobile Number -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mobile_number" class="mb-1">Mobile Number</label>
                                <input type="text" name="mobile_number"
                                    class="form-control <?php $__errorArgs = ['mobile_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="mobile_number"
                                    placeholder="Enter Mobile Number" value="<?php echo e(old('mobile_number',$bssStudent->mobile_number)); ?>" required>
                                <?php $__errorArgs = ['mobile_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Alternative Contact Number -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="alternative_contact_number" class="mb-1">Alternative Contact Number</label>
                                <input type="text" name="alternative_contact_number"
                                    class="form-control <?php $__errorArgs = ['alternative_contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="alternative_contact_number" placeholder="Enter Alternative Contact Number"
                                    value="<?php echo e(old('alternative_contact_number',$bssStudent->alternative_contact_number)); ?>">
                                <?php $__errorArgs = ['alternative_contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Date of Birth -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="dob" class="mb-1">Date of Birth</label>
                                <input type="date" name="dob" class="form-control <?php $__errorArgs = ['dob'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="dob" value="<?php echo e(old('dob',$bssStudent->dob)); ?>" required>
                                <?php $__errorArgs = ['dob'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="blood_group" class="mb-1">Blood Group</label>
                                <select name="blood_group" id="blood_group" class="form-control <?php $__errorArgs = ['blood_group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                    <option value="" disabled>Select Blood Group</option>
                                    <option value="A+" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'A+' ? 'selected' : ''); ?>>A+</option>
                                    <option value="A-" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'A-' ? 'selected' : ''); ?>>A-</option>
                                    <option value="B+" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'B+' ? 'selected' : ''); ?>>B+</option>
                                    <option value="B-" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'B-' ? 'selected' : ''); ?>>B-</option>
                                    <option value="O+" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'O+' ? 'selected' : ''); ?>>O+</option>
                                    <option value="O-" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'O-' ? 'selected' : ''); ?>>O-</option>
                                    <option value="AB+" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'AB+' ? 'selected' : ''); ?>>AB+</option>
                                    <option value="AB-" <?php echo e(old('blood_group', $bssStudent->blood_group) == 'AB-' ? 'selected' : ''); ?>>AB-</option>
                                </select>
                                <?php $__errorArgs = ['blood_group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Area of Residence -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="area_of_residence" class="mb-1">Area of Residence</label>
                                <input type="text" name="area_of_residence" class="form-control <?php $__errorArgs = ['area_of_residence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="area_of_residence" placeholder="Enter Area of Residence" value="<?php echo e(old('area_of_residence', $bssStudent->area_of_residence)); ?>" required>
                                <?php $__errorArgs = ['area_of_residence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Photograph -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="photograph" class="mb-1">Photograph</label>
                                <input type="file" name="photograph" class="form-control <?php $__errorArgs = ['photograph'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="photograph" accept="image/*">
                                    <?php if($bssStudent->photograph): ?>
                                    <a href="<?php echo e(asset('storage/' . $bssStudent->photograph)); ?>" class="btn btn-sm btn-primary mt-1" target="_blank">View Image</a>
                                <?php else: ?>
                                    <p>No photograph uploaded.</p>
                                <?php endif; ?>

                                <?php $__errorArgs = ['photograph'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Mother Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mother_name" class="mb-1">Mother Name</label>
                                <input type="text" name="mother_name" class="form-control <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="mother_name" placeholder="Enter Mother's Name" value="<?php echo e(old('mother_name', $bssStudent->mother_name)); ?>" required>
                                <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Mother Profession -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mother_profession" class="mb-1">Mother's Profession</label>
                                <input type="text" name="mother_profession" class="form-control <?php $__errorArgs = ['mother_profession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="mother_profession" placeholder="Enter Mother's Profession" value="<?php echo e(old('mother_profession', $bssStudent->mother_profession)); ?>" required>
                                <?php $__errorArgs = ['mother_profession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Father Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="father_name" class="mb-1">Father Name</label>
                                <input type="text" name="father_name" class="form-control <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="father_name" placeholder="Enter Father's Name" value="<?php echo e(old('father_name', $bssStudent->father_name)); ?>" required>
                                <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Father Profession -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="father_profession" class="mb-1">Father's Profession</label>
                                <input type="text" name="father_profession" class="form-control <?php $__errorArgs = ['father_profession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="father_profession" placeholder="Enter Father's Profession" value="<?php echo e(old('father_profession', $bssStudent->father_profession)); ?>" required>
                                <?php $__errorArgs = ['father_profession'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- Years of Association with BSS -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="years_of_association_with_bss" class="mb-1">Years of Association with BSS</label>
                                <input type="number" name="years_of_association_with_bss"
                                    class="form-control <?php $__errorArgs = ['years_of_association_with_bss'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="years_of_association_with_bss" placeholder="Enter Years of Association with BSS"
                                    value="<?php echo e(old('years_of_association_with_bss', $bssStudent->years_of_association_with_bss)); ?>" required>
                                <?php $__errorArgs = ['years_of_association_with_bss'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>


                        <!-- Family Association with Gayatri Pariwar -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="family_association_with_gayatri_pariwar" class="mb-1">Family Association with Gayatri Pariwar</label>
                                <select name="family_association_with_gayatri_pariwar"
                                    class="form-control <?php $__errorArgs = ['family_association_with_gayatri_pariwar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="family_association_with_gayatri_pariwar" required>
                                    <option value="" disabled selected>Select an option</option>
                                    <option value="Yes" <?php echo e(old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                                    <option value="No" <?php echo e(old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'No' ? 'selected' : ''); ?>>No</option>
                                    <option value="Maybe" <?php echo e(old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'Maybe' ? 'selected' : ''); ?>>Maybe</option>
                                </select>
                                <?php $__errorArgs = ['family_association_with_gayatri_pariwar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- School Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="school_name" class="mb-1">School Name</label>
                                <input type="text" name="school_name" class="form-control <?php $__errorArgs = ['school_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="school_name" placeholder="Enter School Name" value="<?php echo e(old('school_name', $bssStudent->school_name)); ?>" required>
                                <?php $__errorArgs = ['school_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <!-- School Address -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="school_address" class="mb-1">School Address</label>
                                <textarea name="school_address" class="form-control <?php $__errorArgs = ['school_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="school_address" placeholder="Enter School Address" rows="3" required><?php echo e(old('school_address', $bssStudent->school_address)); ?></textarea>
                                <?php $__errorArgs = ['school_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>



                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="<?php echo e(route('bss.students.index')); ?>" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Update student</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#mobile_number').inputmask('+99 99999 99999');
        });
        $(document).ready(function() {
            $('#alternative_contact_number').inputmask('+99 99999 99999');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/admin/bss/student/edit.blade.php ENDPATH**/ ?>