<nav id="mainNavbar"
    class="main-header navbar navbar-expand <?php if(auth()->check() && auth()->user()->is_dark == 1): ?> navbar-dark <?php else: ?> navbar-white navbar-light <?php endif; ?>">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button" data-toggle="tooltip"
                title="Toggle Sidebar">
                <i class="fas fa-bars"></i>
            </a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="<?php echo e(route('home')); ?>" class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"
                data-toggle="tooltip" title="Go to Home">Home</a>
        </li>
        <li class="nav-item d-none d-sm-inline-block">
            <a href="#" class="nav-link" data-toggle="tooltip" title="Contact Us">Contact</a>
        </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <li class="nav-item">
            <span id="darkModeToggle" class="nav-link" onclick="DarkMode()" role="button" data-toggle="tooltip"
                title="Toggle Dark Mode">
                <i class="fas <?php if(auth()->check() && auth()->user()->is_dark == 0): ?> fa-moon <?php else: ?> fa-sun <?php endif; ?>"></i>
            </span>
        </li>

        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" role="button" data-toggle="tooltip" title="Fullscreen Mode">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#" role="button" aria-haspopup="true"
                aria-expanded="false"style="
                padding-top: 4.5px;
                padding-bottom: 4.5px;
            ">
                <?php if($avatar): ?>
                    <img src="<?php echo e(asset('storage/' . $avatar)); ?>" alt="User Image" class="img-circle" width="30"
                        height="30">
                <?php else: ?>
                    <img src="<?php echo e(getGravatar(Auth::user()->email)); ?>" alt="User Image" class="img-circle" width="30"
                        height="30">
                <?php endif; ?>
            </a>
            <div class="dropdown-menu dropdown-menu-right">
                <a class="dropdown-item" href="#" data-toggle="tooltip" title="User Profile">
                    <i class="fas fa-user mr-2"></i>Profile
                </a>
                <a class="dropdown-item bg-danger" href="<?php echo e(route('logout')); ?>" data-toggle="tooltip" title="Logout"
                    onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                    <i class="fas fa-sign-out-alt mr-2"></i>Logout
                </a>
            </div>
        </li>
        <form id="logout-form" class="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>
    </ul>
</nav>
<?php /**PATH C:\laragon\www\ngo_app_sj\resources\views/partials/navbar.blade.php ENDPATH**/ ?>