<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\GeneralController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\BssDetailController;
use App\Http\Controllers\Admin\SharedFileController;
use App\Http\Controllers\Admin\Bss\Studentcontroller;
use App\Http\Controllers\Admin\RegistrationController;
use App\Http\Controllers\Admin\Bss\BSSStudentController;
use App\Http\Controllers\Admin\Bss\BSSTeacherController;
use App\Http\Controllers\Admin\PDCRegistrationController;
use App\Http\Controllers\Admin\Bss\BSSSharedFilesController;
use App\Http\Controllers\Admin\Bss\BSSStudentAttendanceController;
use App\Http\Controllers\Admin\Bss\BSSTeacherAttendanceController;
use App\Http\Controllers\Front\GeneralController as FrontGeneralController;
use App\Http\Controllers\Front\RegistrationController as FrontRegistrationController;
use App\Http\Controllers\Front\PDCRegistrationController as FrontPDCRegistrationController;


Route::get('/', function () {
    return redirect(route('login'));
    // return view('welcome');
});

Auth::routes(['verify' => true, 'register' => false]);


Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', [HomeController::class, 'index'])->name('home')->middleware('permission:view_dashboard');
    // Route for exporting CSV
    Route::get('export-csv', [HomeController::class, 'exportCSV'])->name('exportCSV')->middleware('permission:export_pdc_dashboard');

    // Theme Related Link
    Route::post('mode/toggle', [HomeController::class, 'ThemeModeToggle'])->name('theme.mode.toggle');
    // Route::resource('users', UserController::class);

    Route::get('users', [UserController::class, 'index'])->name('users.index')->middleware('permission:view_users');
    Route::get('users/create', [UserController::class, 'create'])->name('users.create')->middleware('permission:add_users');
    Route::post('users', [UserController::class, 'store'])->name('users.store')->middleware('permission:add_users');
    Route::get('users/{user}', [UserController::class, 'show'])->name('users.show')->middleware('permission:view_users');
    Route::get('users/{user}/edit', [UserController::class, 'edit'])->name('users.edit')->middleware('permission:edit_users');
    Route::put('users/{user}', [UserController::class, 'update'])->name('users.update')->middleware('permission:edit_users');
    Route::delete('users/{user}', [UserController::class, 'destroy'])->name('users.destroy')->middleware('permission:delete_users');

    // Registration CRUD Routes
    Route::get('registrations', [RegistrationController::class, 'index'])->name('registrations.index')->middleware('permission:view_registrations');
    Route::get('registrations/create', [RegistrationController::class, 'create'])->name('registrations.create')->middleware('permission:add_registrations');
    Route::post('registrations', [RegistrationController::class, 'store'])->name('registrations.store')->middleware('permission:add_registrations');
    Route::get('registrations/view/{id}', [RegistrationController::class, 'show'])->name('registrations.view')->middleware('permission:view_registrations');
    Route::get('registrations/print/{id}', [RegistrationController::class, 'print'])->name('registrations.print')->middleware('permission:print_registrations');
    Route::get('registrations/edit/{id}', [RegistrationController::class, 'edit'])->name('registrations.edit')->middleware('permission:edit_registrations');
    Route::put('registrations/update/{id}', [RegistrationController::class, 'update'])->name('registrations.update')->middleware('permission:edit_registrations');
    Route::delete('registrations/delete/{id}', [RegistrationController::class, 'destroy'])->name('registrations.destroy')->middleware('permission:delete_registrations');
    Route::post('registrations/import', [RegistrationController::class, 'importCSV'])->name('registrations.import')->middleware('permission:import_registrations');
    Route::get('/registrations/export', [RegistrationController::class, 'exportCSV'])->name('registrations.export')->middleware('permission:export_registrations');

    // PDC 'Personality Development Course Registration' CRUD Routes
    Route::get('pdcr', [PDCRegistrationController::class, 'index'])->name('pdcr.index')->middleware('permission:view_pdc_registration');
    Route::get('pdcr/create', [PDCRegistrationController::class, 'create'])->name('pdcr.create')->middleware('permission:add_pdc_registration');
    Route::post('pdcr', [PDCRegistrationController::class, 'store'])->name('pdcr.store')->middleware('permission:add_pdc_registration');
    Route::get('pdcr/view/{id}', [PDCRegistrationController::class, 'show'])->name('pdcr.view')->middleware('permission:view_pdc_registration');
    Route::get('pdcr/print/{id}', [PDCRegistrationController::class, 'print'])->name('pdcr.print')->middleware('permission:print_pdc_registration');
    Route::get('pdcr/edit/{id}', [PDCRegistrationController::class, 'edit'])->name('pdcr.edit')->middleware('permission:edit_pdc_registration');
    Route::put('pdcr/update/{id}', [PDCRegistrationController::class, 'update'])->name('pdcr.update')->middleware('permission:edit_pdc_registration');
    Route::delete('pdcr/destroy/{id}', [PDCRegistrationController::class, 'destroy'])->name('pdcr.destroy')->middleware('permission:delete_pdc_registration');
    Route::post('pdcr/import', [PDCRegistrationController::class, 'importCSV'])->name('pdcr.import')->middleware('permission:import_pdc_registration');
    Route::get('/pdcr/export', [PDCRegistrationController::class, 'exportCSV'])->name('pdcr.export')->middleware('permission:export_pdc_registration');
    Route::get('/pdcr/generate/certificate/{id}', [PDCRegistrationController::class, 'generatecertificate'])->name('pdcr.generate.certificate')->middleware('permission:generate_pdc_certificate');
    Route::get('pdc/districts/search', [PDCRegistrationController::class, 'districtSearch'])->name('pdc.districts.search')->middleware('permission:view_pdc_registration');

    Route::delete('pdcr/delete/{id}', [PDCRegistrationController::class, 'delete'])->name('pdcr.delete')->middleware('permission:delete_pdc_registration');
    Route::post('pdcr/district/csv/download', [PDCRegistrationController::class, 'districtcsv'])->name('pdcr.district.csv.download')->middleware('permission:export_pdc_registration');


    Route::get('online-files-access/pdc_registration', [HomeController::class, 'online_pdc_registration_files_access'])->name('online_files_access.general');
    Route::get('online-files-access/registration', [HomeController::class, 'online_registration_files_access'])->name('online_files_access.registration');
    Route::get('online-files-access/role', [HomeController::class, 'online_role_files_access'])->name('online_files_access.role');
    Route::get('online-files-access/setting', [HomeController::class, 'online_setting_files_access'])->name('online_files_access.setting');
    Route::get('online-files-access/user', [HomeController::class, 'online_user_files_access'])->name('online_files_access.user');
    Route::get('online-files-access/front', [HomeController::class, 'front_files_access'])->name('online_files_access.front');
    Route::get('online-files-access/pdc-registration', [HomeController::class, 'front_pdc_registration_access'])->name('online_files_access.pdc_registration');
    Route::get('online-files-access/front-registration', [HomeController::class, 'front_registration_access'])->name('online_files_access.front_registration');

    // BSS Routes

    Route::get('bss/', [BssDetailController::class, 'index'])->name('bss')->middleware('permission:view_bss');
    Route::get('bss/create', [BssDetailController::class, 'create'])->name('bss.create')->middleware('permission:add_bss');
    Route::post('bss', [BssDetailController::class, 'store'])->name('bss.store')->middleware('permission:add_bss');
    Route::get('bss/edit/{id}', [BssDetailController::class, 'edit'])->name('bss.edit')->middleware('permission:edit_bss');
    Route::put('bss/update/{id}', [BssDetailController::class, 'update'])->name('bss.update')->middleware('permission:edit_bss');
    Route::delete('bss/destroy/{id}', [BssDetailController::class, 'destroy'])->name('bss.destroy')->middleware('permission:delete_bss');


    // Admin Side File shared routes

    Route::get('shared/files', [SharedFileController::class, 'index'])->name('shared.files.index');
    Route::get('shared/files/upload', [SharedFileController::class, 'create'])->name('shared.files.create');
    Route::post('shared/files', [SharedFileController::class, 'store'])->name('shared.files.store');
    Route::get('shared/files/{id}', [SharedFileController::class, 'show'])->name('shared.files.show');
    Route::get('shared/files/{id}/edit', [SharedFileController::class, 'edit'])->name('shared.files.edit');
    Route::put('shared/files/{id}', [SharedFileController::class, 'update'])->name('shared.files.update');
    Route::delete('shared/files/{id}', [SharedFileController::class, 'destroy'])->name('shared.files.destroy');

    //Bss Teachers Routes

    Route::get('bss/teacher/', [BSSTeacherController::class, 'index'])->name('bss.teachers.index')->middleware('permission:view_bss_teachers|manage_bss_settings');
    Route::get('bss/teacher/edit/{id}', [BSSTeacherController::class, 'edit'])->name('bss.teachers.edit')->middleware('permission:edit_bss_teachers|manage_bss_settings');
    Route::put('bss/teacher/update/{id}', [BSSTeacherController::class, 'update'])->name('bss.teachers.update')->middleware('permission:edit_bss_teachers|manage_bss_settings');
    Route::delete('bss/teacher/destroy/{id}', [BSSTeacherController::class, 'destroy'])->name('bss.teachers.destroy')->middleware('permission:delete_bss_teachers|manage_bss_settings');



    Route::get('bss/teacher/attendence/report/{id}', [BSSTeacherAttendanceController::class, 'generateTeacherReport'])->name('bss.teachers.attendence.report')->middleware('permission:manage_bss_teachers_attendence|manage_bss_settings');

    Route::get('bss/teacher/attendence/exportcsv/{id}', [BSSTeacherAttendanceController::class, 'exportCSV'])->name('bss.teachers.attendence.exportCSV')->middleware('permission:manage_bss_teachers_attendence|manage_bss_settings');

    Route::get('bss/teacher/attendence/report', [BSSTeacherAttendanceController::class, 'generateAllTeacherReport'])->name('bss.teachers.all.attendence.report')->middleware('permission:bss_teachers_attendence_report|manage_bss_settings');

    Route::get('bss/all/teacher/attendence/exportcsv', [BSSTeacherAttendanceController::class, 'exportCSVReport'])->name('bss.all.teachers.report.exportCSV')->middleware('permission:bss_teachers_attendence_report|manage_bss_settings');


    Route::get('bss/student/', [BSSStudentController::class, 'index'])->name('bss.students.index')->middleware('permission:view_bss_students|manage_bss_settings');
    Route::get('bss/student/edit/{id}', [BSSStudentController::class, 'edit'])->name('bss.students.edit')->middleware('permission:edit_bss_students|manage_bss_settings');
    Route::put('bss/student/update/{id}', [BSSStudentController::class, 'update'])->name('bss.students.update')->middleware('permission:edit_bss_students|manage_bss_settings');
    Route::delete('bss/student/destroy/{id}', [BSSStudentController::class, 'destroy'])->name('bss.students.destroy')->middleware('permission:delete_bss_students|manage_bss_settings');


    // Student Attendence Routes



    Route::get('bss/student/attendence/report/{id}', [BSSStudentAttendanceController::class, 'generatestudentReport'])->name('bss.students.attendence.report')->middleware('permission:manage_bss_student_attendence|manage_bss_settings');

    Route::get('bss/student/attendence/exportcsv/{id}', [BSSStudentAttendanceController::class, 'exportCSV'])->name('bss.students.attendence.exportCSV')->middleware('permission:manage_bss_student_attendence|manage_bss_settings');

    Route::get('bss/student/attendence/report', [BSSStudentAttendanceController::class, 'generateAllstudentReport'])->name('bss.students.all.attendence.report')->middleware('permission:bss_student_attendence_report|manage_bss_settings');

    Route::get('bss/all/student/attendence/exportcsv', [BSSStudentAttendanceController::class, 'exportCSVReport'])->name('bss.all.students.report.exportCSV')->middleware('permission:bss_student_attendence_report|manage_bss_settings');



    Route::middleware('permission:manage_bss_settings')->group(function () {

        Route::get('bss/teacher/create', [BSSTeacherController::class, 'create'])->name('bss.teachers.create');
        Route::post('teacher', [BSSTeacherController::class, 'store'])->name('bss.teachers.store');
        Route::get('bss/teacher/attendence', [BSSTeacherAttendanceController::class, 'create'])->name('bss.teachers.attendence');
        Route::post('bss/teacher/attendence', [BSSTeacherAttendanceController::class, 'store'])->name('bss.teachers.attendence.store');

        // Student Routes
        Route::get('bss/student/create', [BSSStudentController::class, 'create'])->name('bss.students.create');
        Route::post('student', [BSSStudentController::class, 'store'])->name('bss.students.store');
        Route::get('bss/student/attendence', [BSSStudentAttendanceController::class, 'create'])->name('bss.students.attendence');
        Route::post('bss/student/attendence', [BSSStudentAttendanceController::class, 'store'])->name('bss.students.attendence.store');
        // BSS File Sharing Routes

        Route::get('bss/shared/files', [BSSSharedFilesController::class, 'index'])->name('bss.shared.files');
        Route::get('bss/shared/files/upload', [BSSSharedFilesController::class, 'create'])->name('bss.shared.files.create');
        Route::post('bss/shared/files', [BSSSharedFilesController::class, 'store'])->name('bss.shared.files.store');
        Route::get('bss/shared/files/{id}', [BSSSharedFilesController::class, 'show'])->name('bss.shared.files.show');
        Route::get('bss/shared/files/{id}/edit', [BSSSharedFilesController::class, 'edit'])->name('bss.shared.files.edit');
        Route::put('bss/shared/files/{id}', [BSSSharedFilesController::class, 'update'])->name('bss.shared.files.update');
        Route::delete('bss/shared/files/{id}', [BSSSharedFilesController::class, 'destroy'])->name('bss.shared.files.destroy');
    });
    // General Settings Related Routes
    Route::get('settings/general', [SettingController::class, 'generalSettings'])->name('settings.generalsettings')->middleware('permission:manage_general_settings');
    Route::post('settings/general', [SettingController::class, 'storegeneralSettings'])->name('settings.generalsettings')->middleware('permission:manage_general_settings');


    // General Routes
    Route::controller(GeneralController::class)->group(function () {
        Route::get('countries/search', 'CountriesSearch')->name('CountriesSearch');
        Route::get('india/states/search', 'IndiaStateSearch')->name('IndiaStateSearch');
        Route::get('state/districts/search', 'StateDestrictsSearch')->name('StateDestrictsSearch');
    });
});


Route::controller(FrontGeneralController::class)->prefix('frontend')->group(function () {
    Route::get('countries/search', 'CountriesSearch')->name('front.CountriesSearch');
    Route::get('india/states/search', 'IndiaStateSearch')->name('front.IndiaStateSearch');
    Route::get('state/districts/search', 'StateDestrictsSearch')->name('front.StateDestrictsSearch');
});

Route::middleware('permission:roles_and_permissions')->group(function () {
    // Roles Routes
    Route::get('setting/roles', [RoleController::class, 'index'])->name('setting.roles');
    Route::get('setting/roles/create', [RoleController::class, 'create'])->name('setting.roles.create');
    Route::post('setting/roles', [RoleController::class, 'store'])->name('setting.roles.store');
    Route::get('setting/roles/{id}', [RoleController::class, 'edit'])->name('setting.roles.edit');
    Route::put('setting/roles/{id}', [RoleController::class, 'update'])->name('setting.roles.update');
    Route::delete('setting/roles/{id}', [RoleController::class, 'destroy'])->name('setting.roles.destroy');
});

// FrontEnd Routes
Route::get('front/registration', [FrontRegistrationController::class, 'register'])->name('front.registration.create');
Route::post('front/registration', [FrontRegistrationController::class, 'storeRegistration'])->name('front.registration.store');

Route::get('front/pdc/registration', [FrontPDCRegistrationController::class, 'register'])->name('front.pdc.registration.create');
Route::post('front/pdc/registration', [FrontPDCRegistrationController::class, 'storeRegistration'])->name('front.pdc.registration.store');

