<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="{{ route('home') }}" class="brand-link">
        <img src="{{ asset('assets/dist/img/AdminLTELogo.png') }}" alt="AdminLTE Logo"
            class="brand-image img-circle elevation-3" style="opacity: .8">
        <span class="brand-text font-weight-light">AdminLTE 3</span>
    </a>
    {{-- <a href="{{ route('home') }}" class="brand-link">
        <img src="{{ asset(env('APP_ICON')) }}" alt="Leadsgenie Logo" class="brand-image logo-main">
        <span class="brand-text font-weight-light logo-main-text"><strong>Leads
                Genie</strong></span>
    </a> --}}
    <div class="sidebar">
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                @if ($avatar)
                    <img src="{{ asset('storage/' . $avatar) }}" style="height: 35px; width: 35px"
                        class="img-circle elevation-2" alt="User Image">
                @else
                    <img src="{{ getGravatar(Auth::user()->email) }}" class="img-circle elevation-2" alt="User Image">
                @endif
            </div>

            <div class="info">
                <a href="#" class="d-block">Alexander Pierce</a>
            </div>
        </div>
        <div class="form-inline mt-2">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search"
                    aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar"><i class="fas fa-search fa-fw"></i></button>
                </div>
            </div>
        </div>
        @if (auth()->user()->type == 'bss')
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    @can('view_dashboard')
                        <li class="nav-item" data-toggle="tooltip" title="Dashboard">
                            <a href="{{ route('home') }}" class="nav-link @if (request()->routeIs('home')) active @endif">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                    @endcan
                    @can('manage_bss_settings')
                        <li class="nav-item" data-toggle="tooltip" title="Teachers">
                            <a href="{{ route('bss.teachers.index') }}"
                                class="nav-link @if (request()->routeIs('bss.teacher*')) active @endif">
                                <i class="nav-icon fas fa-chalkboard-teacher"></i>
                                <p>Teachers</p>
                            </a>
                        </li>
                        <li class="nav-item" data-toggle="tooltip" title="Students">
                            <a href="{{ route('bss.students.index') }}"
                                class="nav-link @if (request()->routeIs('bss.students*')) active @endif">
                                <i class="nav-icon fas fa-graduation-cap"></i>

                                <p>Students</p>
                            </a>
                        </li>
                        <li class="nav-item" data-toggle="tooltip" title="Shared Files With Office">
                            <a href="{{ route('bss.shared.files') }}"
                                class="nav-link @if (request()->routeIs('bss.shared.files*')) active @endif">
                                <i class="nav-icon fas fa-file"></i>
                                <p>Share Files With Office</p>
                            </a>
                        </li>
                    @endcan
                    <li class="nav-item" data-toggle="tooltip" title="Logout Now">
                        <a href="{{ route('logout') }}"
                            onclick="event.preventDefault(); document.getElementsByClassName('logout-form')[0].submit();"
                            class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <p>Logout Now</p>
                        </a>
                    </li>
                </ul>
            </nav>
        @else
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                    data-accordion="false">
                    @can('view_dashboard')
                        <li class="nav-item" data-toggle="tooltip" title="Dashboard">
                            <a href="{{ route('home') }}" class="nav-link @if (request()->routeIs('home')) active @endif">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                    @endcan
                    @canany(['view_registrations', 'add_registrations', 'edit_registrations', 'delete_registrations'])
                        <li class="nav-item" data-toggle="tooltip" title="Registration">
                            <a href="{{ route('registrations.index') }}"
                                class="nav-link @if (request()->routeIs('registrations*')) active @endif">
                                <i class="nav-icon fas fa-registered"></i>
                                <p>Registrations</p>
                            </a>
                        </li>
                    @endcanany
                    @canany(['view_pdc_registration', 'add_pdc_registration', 'edit_pdc_registration',
                        'delete_pdc_registration'])
                        <li class="nav-item" data-toggle="tooltip" title="Personality Development Course Registrations">
                            <a href="{{ route('pdcr.index') }}"
                                class="nav-link @if (request()->routeIs('pdcr*')) active @endif">
                                <i class="nav-icon fas fa-graduation-cap"></i>
                                <p>PDC Registrations
                                </p>
                            </a>
                        </li>
                    @endcanany

                    @canany(['roles_and_permissions', 'manage_general_settings'])
                        <li
                            class="nav-item {{ Request::routeIs('settings.generalsettings') || Request::routeIs('setting.roles') ? 'menu-is-opening menu-open' : '' }}">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-cog"></i>
                                <p>
                                    Settings
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview"
                                style="display: {{ Request::routeIs('settings.generalsettings') || Request::routeIs('setting.roles') ? 'block' : 'none' }};">
                                @can('manage_general_settings')
                                    <li class="nav-item" data-toggle="tooltip" title="General Settings">
                                        <a href="{{ route('settings.generalsettings') }}"
                                            class="nav-link {{ Request::routeIs('settings.generalsettings') ? 'active' : '' }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>General Settings</p>
                                        </a>
                                    </li>
                                @endcan
                                @can('roles_and_permissions')
                                    <li class="nav-item" data-toggle="tooltip" title="Roles">
                                        <a href="{{ route('setting.roles') }}"
                                            class="nav-link {{ Request::routeIs('setting.roles') ? 'active' : '' }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Roles</p>
                                        </a>
                                    </li>
                                @endcan
                            </ul>
                        </li>
                    @endcanany
                    @canany(['view_users', 'add_users', 'edit_users', 'delete_users'])
                        <li class="nav-item" data-toggle="tooltip" title="Manage Users">
                            <a href="{{ route('users.index') }}"
                                class="nav-link @if (request()->routeIs('users*')) active @endif">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Users
                                </p>
                            </a>
                        </li>
                    @endcanany
                    @canany(['view_bss', 'add_bss', 'edit_bss', 'delete_bss', 'view_bss_teachers', 'edit_bss_teachers',
                        'delete_bss_teachers', 'view_bss_teacher_attendences', 'bss_teachers_attendence_report',
                        'add_bss_teacher_attendence', 'view_bss_students', 'edit_bss_students', 'delete_bss_students',
                        'view_bss_student_attendences', 'bss_students_attendence_report', 'add_bss_student_attendence'])
                        <li class="nav-item" data-toggle="tooltip" title="Bal Sewa Samaj (BSS)">
                            <a href="{{ route('bss') }}"
                                class="nav-link {{ request()->routeIs('bss') || request()->routeIs('bss.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-users"></i>
                                <p>Manage BSS <i class="right fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview"
                                style="display: {{ request()->routeIs('bss.*') || request()->routeIs('bss') ? 'block' : 'none' }};">
                                @can('view_bss')
                                    <li class="nav-item">
                                        <a href="{{ route('bss') }}"
                                            class="nav-link {{ request()->routeIs('bss') ? 'active' : '' }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>Manage BSS</p>
                                        </a>
                                    </li>
                                @endcan
                                @can('view_bss_teachers')
                                    <li class="nav-item">
                                        <a href="{{ route('bss.teachers.index') }}"
                                            class="nav-link {{ request()->routeIs('bss.teachers.*') ? 'active' : '' }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>BSS Teachers</p>
                                        </a>
                                    </li>
                                @endcan
                                @can('view_bss_students')
                                    <li class="nav-item">
                                        <a href="{{ route('bss.students.index') }}"
                                            class="nav-link {{ request()->routeIs('bss.students.*') ? 'active' : '' }}">
                                            <i class="far fa-circle nav-icon"></i>
                                            <p>BSS Students</p>
                                        </a>
                                    </li>
                                @endcan
                            </ul>
                        </li>
                    @endcanany

                    @canany(['view_files', 'delete_files'])
                        <li class="nav-item" data-toggle="tooltip" title="Shared Files With Office">
                            <a href="{{ route('shared.files.index') }}"
                                class="nav-link @if (request()->routeIs('shared.files.index*')) active @endif">
                                <i class="nav-icon fas fa-file"></i>
                                <p>Shared Files With Office</p>
                            </a>
                        </li>
                    @endcanany
                    <li class="nav-item" data-toggle="tooltip" title="Logout Now">
                        <a href="{{ route('logout') }}"
                            onclick="event.preventDefault(); document.getElementsByClassName('logout-form')[0].submit();"
                            class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <p>Logout Now</p>
                        </a>
                    </li>
                </ul>
            </nav>
        @endif
    </div>
</aside>
