<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('page_title') | {{ config('app.name') }}</title>
    <link rel="stylesheet" href="{{ asset('assets/dist/css/adminlte.min.css') }}">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
</head>

<body>
    @yield('content')
    <!-- jQuery -->
    <script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/inputmask/jquery.inputmask.min.js') }}"></script>
    <!-- Select2 -->
    <script src="{{ asset('assets/plugins/select2/js/select2.full.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#mobile_number').inputmask('+99 99999 99999');

            $('.select2').select2({
                theme: 'bootstrap4',
            });

            $('#IndiaStates').select2({
                theme: 'bootstrap4',
                placeholder: 'Select State of India',
                tokenSeparators: [','],
                ajax: {
                    url: '{{ route('front.IndiaStateSearch') }}',
                    dataType: 'json',
                    data: function(params) {
                        let query = {
                            q: params.term,
                        };
                        return query;
                    },
                    processResults: function(data) {
                        return {
                            results: data.map(function(item) {
                                return {
                                    id: item.id,
                                    text: item.name + (item.name_hindi ? ' (' + item.name_hindi + ')' : '')
                                };
                            })
                        };
                    },
                    cache: true
                }
            });


            //SELECT CITIES BASED ON States SELECTED
            $('#IndiaStates').on('change', function() {
                var $state_id = $("#IndiaStates").val();
                $("#Districts").html("");

                $('#Districts').select2({
                    theme: 'bootstrap4',
                    placeholder: 'Select District of State',
                    tokenSeparators: [','],

                    ajax: {
                        url: '{{ route('front.StateDestrictsSearch') }}',
                        dataType: 'json',
                        data: function(params) {
                            return {
                                c: $state_id,
                                q: params.term,
                            };
                        },
                        processResults: function(data) {
                            return {
                                results: data.map(function(item) {
                                    return {
                                        id: item.id,
                                        text: item.name + (item.name_hindi ? ' (' + item.name_hindi + ')' : '')
                                    }
                                })
                            }
                        },
                        cache: true
                    }
                });
            });
        });
    </script>
</body>

</html>
