<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('page_title') | {{ config('app.name') }}</title>

    <link rel="icon" href="{{ asset(env('APP_ICON')) }}">
    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('assets/dist/css/adminlte.min.css') }}">
</head>

<body class="hold-transition register-page">
    <style>
        .dark-mode-toggle {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 50px;
            height: 50px;
            background-color: lightgray;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }

        .dark-mode-toggle i {
            font-size: 24px;
            color: white;
        }

        .dark-mode input:-webkit-autofill,
        .dark-mode input:-webkit-autofill:focus,
        .dark-mode input:-webkit-autofill:hover,
        .dark-mode select:-webkit-autofill,
        .dark-mode select:-webkit-autofill:focus,
        .dark-mode select:-webkit-autofill:hover,
        .dark-mode textarea:-webkit-autofill,
        .dark-mode textarea:-webkit-autofill:focus,
        .dark-mode textarea:-webkit-autofill:hover {
            -webkit-text-fill-color: black;
        }
    </style>
    @stack('styles')
    @yield('content')

    <!-- Dark Mode Toggle Button -->
    <div class="dark-mode-toggle bg-dark" id="darkModeToggle">
        <i class="fas fa-moon"></i>
    </div>
    <!-- jQuery -->
    <script src="{{ asset('assets/plugins/jquery/jquery.min.js') }}"></script>
    <!-- Bootstrap 4 -->
    <script src="{{ asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- AdminLTE App -->
    <script src="{{ asset('assets/dist/js/adminlte.min.js') }}"></script>
    @stack('scripts')
    <script>
        $(document).ready(function() {
            // Function to apply dark mode based on saved preference
            function applyDarkMode(isDarkMode) {
                var icon = $("#darkModeToggle i");

                if (isDarkMode) {
                    icon.removeClass("fa-moon").addClass("fa-sun");
                    $('#mainNavbar').addClass('navbar-dark').removeClass('navbar-white navbar-light');
                    $('body').addClass('dark-mode');
                    $('.border-class').addClass('dark');
                } else {
                    icon.removeClass("fa-sun").addClass("fa-moon");
                    $('#mainNavbar').removeClass('navbar-dark').addClass('navbar-white navbar-light');
                    $('body').removeClass('dark-mode');
                    $('.border-class').removeClass('dark');
                }
            }

            // Check the saved mode from localStorage and apply it
            var isDarkMode = localStorage.getItem('darkMode') === 'true';
            applyDarkMode(isDarkMode);

            // Toggle function to switch modes and save preference
            function toggleDarkMode() {
                var isCurrentlyDark = $('body').hasClass('dark-mode');
                var newMode = !isCurrentlyDark;

                applyDarkMode(newMode);

                // Save the new mode in localStorage
                localStorage.setItem('darkMode', newMode);
            }

            // Click event to toggle dark mode
            $("#darkModeToggle").click(function() {
                toggleDarkMode();
            });
        });
    </script>

</body>

</html>
