@extends('layouts.app')
@section('page_title', 'Dashboard')
@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            @if (auth()->user()->type == 'bss')
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h4>{{ $bsscount ?? 'N/A' }}</h4>
                            <p>Total BSS Registered</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
            @else
                <!-- Small boxes (Stat box) -->
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h4>{{ $usercount }}</h4>

                                <p>Total Members</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h4>{{ $userlast->name ?? 'N/A' }}</h4>

                                <p>New Registered Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-stats-bars"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h4>{{ $pdccount }}</h4>

                                <p>Total PDC Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h4>{{ $pdclast->name ?? 'N/A' }}</h4>
                                <p>New PDC Added Member</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-pie-graph"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i
                                    class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header d-flex align-items-center">
                                <div class="col-md-3">
                                    <h3 class="card-title">Recent PDC Registration</h3>
                                </div>
                                <div class="col-md-9 text-right">
                                    <form action="{{ route('home') }}" method="GET">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <input type="date" id="fromDate" name="fromDate" class="form-control"
                                                    placeholder="From Date" value="{{ request('fromDate') }}">
                                            </div>
                                            <div class="col-md-4">
                                                <input type="date" id="toDate" value="{{ request('toDate') }}"
                                                    name="toDate" class="form-control" placeholder="To Date">
                                            </div>
                                            <div class="col-md-4">
                                                <button type="submit" id="searchBtn"
                                                    class="btn btn-primary btn-sm">Search</button>
                                                <a href="{{ route('home') }}" class="btn btn-secondary btn-sm">Cancel</a>
                                                @can('export_pdc_dashboard')
                                                    <a href="{{ route('exportCSV', ['fromDate' => request('fromDate'), 'toDate' => request('toDate')]) }}"
                                                        class="btn btn-info btn-sm" id="exportcsv">Export CSV</a>
                                                @endcan
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <table id="pdcTable" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Registration</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone No</th>
                                            <th>Added By</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($pdcregistration as $pdcreg)
                                            <tr>
                                                <td>{{ $pdcreg->reg_no }}</td>
                                                <td>{{ $pdcreg->name }}</td>
                                                <td>{{ $pdcreg->email }}</td>
                                                <td>{{ $pdcreg->mobile_number }}</td>
                                                <td>{{ $pdcreg->added_by }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- DataTables Script -->


                    <!-- /.row -->

                </div><!-- /.container-fluid -->
            @endif
    </section>
    <!-- /.content -->
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            // Initialize DataTable with export buttons
            var table = $('#pdcTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'csvHtml5',
                    text: 'Export CSV',
                    title: 'PDC_Registration_Data'
                }]
            });
        });
    </script>
@endpush
