@extends('layouts.auth')
@section('page_title', 'Verify Email')
@section('content')
    <div class="login-box">
        <div class="card card-outline card-primary">
            <div class="card-header text-center">
                <span class="h1"><b>Verify</b> Email</a>
            </div>
            <div class="card-body">
                <p class="login-box-msg">{{ __('Before proceeding, please check your email for a verification link.') }}</p>
                <p class="login-box-msg">{{ __('If you did not receive the email') }}</p>
                @if (session('resent'))
                    <div class="alert alert-success mb-1" role="alert">
                        {{ __('A fresh verification link has been sent to your email address.') }}
                    </div>
                @endif
                <form class="d-inline" method="POST" action="{{ route('verification.resend') }}">
                    @csrf
                    <button type="submit"
                        class="btn btn-primary btn-block">{{ __('Click here to request another') }}</button>
                </form>
            </div>
        </div>
    </div>
@endsection
