@extends('layouts.app')
@section('page_title', 'General Settings')

@section('content')
    <!-- Dashboard Ecommerce Starts -->
    <section id="dashboard-ecommerce">
        <div class="card shadow-sm">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">Manage General Settings</h4>
            </div>
            <form action="{{ route('settings.generalsettings') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <!-- Prefix/Suffix Text Field -->
                            <label for="prefix_suffix_text" class="mb-1">Prefix/Suffix Text</label>
                            <input type="text" name="prefix_suffix"
                                class="form-control @error('prefix_suffix') is-invalid @enderror" id="prefix_suffix_text"
                                placeholder="Enter Prefix or Suffix Text"
                                value="{{ old('prefix_suffix', $settings->prefix_suffix ?? '') }}">
                            <small class="text-muted">This text will be displayed along with the registration number,
                                e.g., "prefix-12345" or "12345-suffix".</small>
                            @error('prefix_suffix')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Prefix/Suffix Radio Buttons -->
                        <div class="col-md-4 mt-1">
                            <label class="mb-1">Prefix or Suffix</label><br>
                            <div class="form-check form-check-inline">
                                <input type="radio" name="prefix_suffix_bit" value="1" id="prefix"
                                    class="form-check-input"
                                    {{ old('prefix_suffix_bit', $settings->prefix_suffix_bit ?? 1) == '1' ? 'checked' : '' }}>
                                <label for="prefix" class="form-check-label">Prefix</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input type="radio" name="prefix_suffix_bit" value="0" id="suffix"
                                    class="form-check-input"
                                    {{ old('prefix_suffix_bit', $settings->prefix_suffix_bit ?? 0) == '0' ? 'checked' : '' }}>
                                <label for="suffix" class="form-check-label">Suffix</label>
                            </div>
                            @error('prefix_suffix_bit')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Front PDC Registration Link Checkbox -->
                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <!-- Hidden input to send 0 if checkbox is unchecked -->
                                <input type="hidden" name="front_pdcr_bit" value="0">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" value="1" id="customSwitch1"
                                        name="front_pdcr_bit"
                                        {{ old('front_pdcr_bit', $settings->front_pdcr_bit ?? 0) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="customSwitch1">Frontend PDC Registrations
                                        Link</label>
                                </div>
                                @error('front_pdcr_bit')
                                    <div class="invalid-feedback d-block">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                    </div>
                </div>
                <div class="card-footer text-end mt-2">
                    <button type="submit" class="btn btn-primary me-1" data-bs-toggle="tooltip"
                        title="Save Settings">{{ __('Save') }}</button>
                </div>
            </form>
        </div>
    </section>
    <!-- Dashboard Ecommerce ends -->
@endsection
