@extends('layouts.app')
@section('page_title', 'Edit Role')

@section('content')

    <!-- Edit Role Starts -->
    <section id="edit-role">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Edit Role</h3>
                    <div>
                        <a href="{{ route('setting.roles') }}" data-bs-toggle="tooltip" title="Go back to the role list"
                            class="btn btn-warning">Back</a>
                    </div>
                </div>
            </div>
            <form action="{{ route('setting.roles.update', $role->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="form-group">
                        <label for="roleName">Role Name</label>
                        <input type="text" class="form-control" id="roleName" name="name" value="{{ $role->name }}"
                            required>
                        @error('name')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <h4 class="mt-4">Manage Permissions</h4>
                    <div class="row">
                        @foreach ($permissions as $module => $modulePermissions)
                            <div class="col-md-12">
                                <h5 class="pt-2 pb-2"><strong>{{ $module }}:</strong></h5>
                                <div class="row">
                                    @foreach ($modulePermissions as $key => $value)
                                        <div class="col-md-3 mb-1">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input"
                                                    id="permission_{{ $key }}" name="permissions[]"
                                                    value="{{ $key }}"
                                                    @if (checkPermissions($key)) {{ $role->hasPermissionTo($key) ? 'checked' : '' }} @endif>
                                                <label class="custom-control-label" for="permission_{{ $key }}">
                                                    {{ $value }}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                    @error('permissions')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        @endforeach

                    </div>


                </div>
                <div class="card-footer text-right">
                    <button type="submit" class="btn btn-primary btn-sm">Update Role</button>
                </div>
            </form>
        </div>
    </section>
@endsection
