@extends('layouts.app')
@section('page_title', 'Add Role')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Create PDC Registration</h3>
                <a href="{{ route('setting.roles') }}" class="btn btn-secondary btn-sm" title="Go Back">Go Back</a>
            </div>
            <form action="" method="POST" enctype="multipart/form-data" id="form">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <!-- Name -->
                        <div class="form-group col-md-6">
                            <label for="name">Name</label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                id="name" value="{{ old('name') }}" placeholder="Enter Full Name" required>
                            @error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Create Registration</button>
                    </div>
                </div>

            </form>
        </div>
    </div>

@endsection
@push('scripts')
    @include('admin.pdcr._scripts')
@endpush
