@extends('layouts.app')
@section('page_title', 'View Registration')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Registration Details</h3>
                <a href="{{ route('registrations.index') }}" class="btn btn-secondary btn-sm" title="Go Back">Go Back</a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <strong>Name:</strong>
                        <p>{{ $registration->name }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Father's Name:</strong>
                        <p>{{ $registration->father_name }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Mother's Name:</strong>
                        <p>{{ $registration->mother_name }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Date of Birth:</strong>
                        <p>{{ \Carbon\Carbon::parse($registration->date_of_birth)->format('d M, Y') }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Email:</strong>
                        <p>{{ $registration->email }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Mobile Number:</strong>
                        <p>{{ $registration->mobile_number }}</p>
                    </div>

                    <div class="col-md-6">
                        <strong>Village:</strong>
                        <p>{{ $registration->village }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Police Station:</strong>
                        <p>{{ $registration->police_station }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>State:</strong>
                        <p>{{ $registration->state->name ?? 'N/A' }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>District:</strong>
                        <p>{{ $registration->district->name ?? 'N/A' }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Block:</strong>
                        <p>{{ $registration->block }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Date:</strong>
                        <p>{{ \Carbon\Carbon::parse($registration->date)->format('d M, Y') }}</p>
                    </div>
                    <div class="col-md-12">
                        <strong>Educational Qualifications:</strong>
                        <p>{{ $registration->educational_qualifications?? 'N/A' }}</p>
                    </div>
                    <div class="col-md-6 ">
                        <strong>Postal Code:</strong>
                        <p>{{ $registration->postal_code ?? 'N/A' }}</p>
                    </div>
                    <div class="col-md-6">
                        <strong>Photo:</strong><br>
                        @if ($registration->photo)
                            <a href="{{ asset('storage/' . $registration->photo) }}" target="_blank"
                                class="btn btn-sm btn-info mt-1">View Current Photo</a>
                        @else
                            <p>No photo available.</p>
                        @endif
                    </div>
                    <div class="col-md-6">
                        <strong>Signature:</strong><br>
                        @if ($registration->signature)
                            <a href="{{ asset('storage/' . $registration->signature) }}" target="_blank"
                                class="btn btn-sm btn-info mt-1">View Current Signature</a>
                        @else
                            <p>No signature available.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
