@extends('layouts.app')
@section('page_title', 'Manage Registrations')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Registrations</h3>
                <div>
                    @can('import_registrations')
                        <button class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#importCsvModal">Import
                            CSV</button>
                    @endcan

                    @can('export_registrations')
                        <a href="{{ route('registrations.export') }}">
                            <button class="btn btn-primary btn-sm">Export CSV</button>
                        </a>
                    @endcan

                    @can('add_registrations')
                        <a href="{{ route('registrations.create') }}">
                            <button class="btn btn-info btn-sm">Create New</button>
                        </a>
                    @endcan
                </div>
            </div>
            <div class="card-body table-responsive">
                {{ $dataTable->table() }}
            </div>
        </div>
    </div>

    @include('admin.registrations.import_csv_model')
@endsection

@include('includes._datatables')
