<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Document View</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .document-container {
            border: 2px solid black;
            padding: 20px;
            max-width: 100%;
            margin: 20px auto;
            font-family: Arial, sans-serif;
            font-size: 14px;
            line-height: 1.5;
        }

        .header {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            color: red;
        }

        .sub-header {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            color: #000;
        }

        .photo-box {
            border: 1px solid black;
            width: 100px;
            height: 120px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 14px;
            color: grey;
        }

        .instructions {
            font-weight: bold;
            color: red;
        }

        .contact-info,
        .footer {
            text-align: center;
            font-size: 14px;
            margin-top: 20px;
        }

        p {
            font-size: 16px;
        }

        .sidebar_box {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .image_place {
            border: 2px solid black;
            border-radius: 10px;
            min-height: 180px;
            position: relative;
            overflow: hidden;
        }

        .image_place_p {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .name_place {
            border: 2px solid black;
            border-radius: 10px;
            min-height: 40px;
            font-size: 20px;
            text-align: center;
        }

        ul li {
            list-style: none;
            font-size: 17px;
        }

        ul {
            padding: 0;
        }

        @media print {
            .row {
                flex-wrap: nowrap;
                width: 100%;
            }

            /* @page {
                size: landscape;
            } */
        }

        .min_box {
            display: inline-block;
            width: 25px;
            height: 25px;
            border: 1px solid black;
            background-color: #fff;
            border-radius: 4px;
            text-align: center;
        }

        .image_box {
            display: flex;
            flex-direction: column;
            gap: 10px;

        }
    </style>
</head>

<body>

    <div class="document-container">

        <!-- Header -->
        <div class="header">
            <div class="container">
                <div class="row">
                    <div class="col-md-3">
                        <img src="{{ asset('assets/images/registration_templates_images/image3.jpg') }}" height="70px"
                            alt="logo">
                        <img src="{{ asset('assets/images/registration_templates_images/image2.jpg') }}" height="70px"
                            alt="logo">
                    </div>
                    <div class="col-md-6">
                        प्रांतीय युवा प्रकोष्ठ, बिहार<br>
                        <div class="sub-header"> सदस्य-परिचय </div>
                    </div>
                    <div class="col-md-3">
                        <img src="{{ asset('assets/images/registration_templates_images/image1.jpg') }}" height="70px"
                            alt="logo">
                    </div>
                </div>
            </div>

        </div>

        <div class="mt-4">
            <div class="row">
                <div class="col-md-9">
                    <div>
                        @php
                            $prefixSuffix = getsettings('prefix_suffix');
                            $prefixSuffixBit = getsettings('prefix_suffix_bit');
                        @endphp
                        <div class="d-flex gap-3 align-items-center">
                            <p>1. पंजीयन संख्या
                                <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $prefixSuffixBit == 1
                                        ? $prefixSuffix . ($registration->reg_no ?? '')
                                        : ($registration->reg_no ?? '') . $prefixSuffix }}
                                </strong>
                            </p>
                            <div class="d-flex gap-3">
                                <p>2. जन्म तिथि</p>

                                <?php
                                // Check if date_of_birth is empty
                                if (!empty($registration->date_of_birth)) {
                                    // Split the date of birth into day, month, and year components
                                    $dob = \Carbon\Carbon::parse($registration->date_of_birth);
                                    $day = str_split($dob->format('d'));
                                    $month = str_split($dob->format('m'));
                                    $year = str_split($dob->format('Y'));
                                } else {
                                    // If empty, set empty arrays for day, month, and year
                                    $day = ['', ''];
                                    $month = ['', ''];
                                    $year = ['', '', '', ''];
                                }
                                ?>

                                <div class="d-flex gap-3">
                                    <!-- Day -->
                                    <div class="d-flex gap-2">
                                        @foreach ($day as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                    <!-- Month -->
                                    <div class="d-flex gap-2">
                                        @foreach ($month as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                    <!-- Year -->
                                    <div class="d-flex gap-2">
                                        @foreach ($year as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="d-flex gap-3 align-items-center">
                            <p>3. पूरा नाम <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $registration->name ?? '' }}</strong>
                            </p>
                            <div class="d-flex gap-3">
                                <p>4. सदस्यता तिथि</p>

                                <?php
                                // Check if registration date is set
                                if (!empty($registration->date)) {
                                    // Split the registration date into day, month, and year components
                                    $regDate = \Carbon\Carbon::parse($registration->date);
                                    $regDay = str_split($regDate->format('d'));
                                    $regMonth = str_split($regDate->format('m'));
                                    $regYear = str_split($regDate->format('Y'));
                                } else {
                                    // If empty, set empty arrays for day, month, and year
                                    $regDay = ['', ''];
                                    $regMonth = ['', ''];
                                    $regYear = ['', '', '', ''];
                                }
                                ?>

                                <div class="d-flex gap-3">
                                    <!-- Day -->
                                    <div class="d-flex gap-2">
                                        @foreach ($regDay as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                    <!-- Month -->
                                    <div class="d-flex gap-2">
                                        @foreach ($regMonth as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                    <!-- Year -->
                                    <div class="d-flex gap-2">
                                        @foreach ($regYear as $digit)
                                            <span class="min_box">{{ $digit }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="d-flex gap-3 align-items-center">
                            <p>5. पिता का नाम <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $registration->father_name ?? '' }}</strong></p>
                            <p>6. माता का नाम <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $registration->mother_name ?? '' }}</strong></p>
                        </div>
                        <div class="d-flex gap-3 align-items-center">
                            <p>7. जिला <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $registration->district['name'] ?? '' }}</strong></p>
                            <p>8. राज्य <strong style="border-bottom: 1px dotted #000;">:
                                    {{ $registration->state['name'] ?? '' }}</strong></p>
                        </div>
                    </div>
                    <div class="instructions">
                        आवश्यक निर्देश:
                    </div>
                    <ul>
                        <li>1. प्रत्येक सदस्य के लिए न्यूनतम 20 मिनट की गायत्री उपासना करना अनिवार्य है | </li>
                        <li>2. प्रकोष्ठ सदस्य प्रतिदिन कम से कम 2 पेज स्वधयाय करे एवं अपने दोस्तों / रिश्तेदारों की
                            सकारात्मक सोच भी
                            विकसित करने वाली क्रांति अभियान / अन्य साहित्य को पढ़ाने का कार्य करें |
                        </li>
                    </ul>
                </div>
                <div class="col-md-3 sidebar_box">
                    <div class="image_box">
                        <div class="image_place">
                            @if (isset($registration->photo))
                                <img src="{{ asset('storage/' . $registration->photo) }}"
                                    style="width: 100%; height: 180px;" alt="">
                            @else
                                <p class="image_place_p">वाली क्रांति</p>
                            @endif
                        </div>
                        <div class="name_place">Name here</div>
                        <span class="text-center text-danger">वाली क्रांति</span>
                    </div>
                </div>
            </div>
        </div>

        <ul>
            <li>3. प्रत्येक सदस्य नारी / देवी के प्रति मातृत्व भाव एवं पवित्र दृस्टि विकसित करें , इससे आप के भीतर
                संतुलन
                आएगा | आप अपने कार्य / पढाई को अच्छी तरह से नियंत्रित कर पाएंगे | </li>
            <li>4. प्रत्येक सदस्य व्यक्तिगत विकास के प्रमुख सूत्र (क) साधना (ख) स्वधयाय (ग) संयम (घ) सेवा का
                निष्ठापूवर्क
                पालन करेंगे |
            </li>
            <li>5. भेंट मुलाकात के दौरान हरेक भाई एक दूसरे को हाथ जोड़कर अभिवादन करेगें |
            </li>
        </ul>

        <!-- Contact Information -->
        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-12">
                        <strong style="color: red;">संपर्क करें</strong>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        वेबसाइट:
                    </div>
                    <div class="col-md-9">
                        <a href="http://www.awgp.org">www.awgp.org</a> | <a
                            href="http://www.pypbihar.org">www.pypbihar.org</a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        ई-मेल:
                    </div>
                    <div class="col-md-9">
                        pypbihar@gmail.com
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        फ़ोन:
                    </div>
                    <div class="col-md-9">
                        0612-2355388, 9430832777, 9431098265
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex flex-column align-items-center gap-2">
                    <span style="font-size: 18px; color: red;">निवेदक</span>
                    <span>प्रांतीय युवा प्रकोष्ठ, बिहार</span>
                    <span>गायत्री शक्तिपीठ, कंकड़बाग -20</span>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer" style="color: red;">
            <p>गायत्री शक्तिपीठ , कंकड़बाग पटना - 20
                प्रांतीय युवा प्रकोष्ठ परिवार आपको दीर्घायु , सफल एवं मंगलमय जीवन की कामना करता है </p>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            window.print();
        });
    </script>
</body>

</html>
