@extends('layouts.app')
@section('page_title', 'Manage PDC Registrations')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">PDC Registrations</h3>
                <div>
                    @can('import_pdc_registration')
                        <button class="btn btn-secondary btn-sm" data-toggle="modal" data-target="#importCsvModal">Import
                            CSV</button>
                    @endcan
                    <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#districtmodel">Search
                        District</button>

                    @can('export_pdc_registration')
                        <a href="{{ route('pdcr.export') }}">
                            <button class="btn btn-primary btn-sm">Export CSV</button>
                        </a>
                    @endcan
                    @can('add_pdc_registration')
                        <a href="{{ route('pdcr.create') }}">
                            <button class="btn btn-info btn-sm">Create New</button>
                        </a>
                    @endcan
                </div>
            </div>
            <div class="card-body table-responsive">
                {{ $dataTable->table() }}
            </div>
        </div>
    </div>

    @include('admin.pdcr.import_csv_model')
    @include('admin.pdcr.district_search_model')
@endsection

@include('includes._datatables')
