@extends('layouts.app')
@section('page_title', 'Edit Registration')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Edit Registration</h3>
                <a href="{{ route('pdcr.index') }}" class="btn btn-secondary btn-sm" title="Go Back">Go Back</a>
            </div>
            <form action="{{ route('pdcr.update', $registration->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="row">
                        <!-- Name -->
                        <div class="form-group col-md-6">
                            <label for="name">Name</label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                id="name" value="{{ old('name', $registration->name) }}" placeholder="Enter Full Name"
                                required>
                            @error('name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- Name Hindi -->
                        <div class="form-group col-md-6">
                            <label for="hindi_name">Name (हिन्दी)</label>
                            <input type="text" name="hindi_name" class="form-control @error('hindi_name') is-invalid @enderror"
                                id="hindi_name" value="{{ old('hindi_name', $registration->hindi_name) }}" placeholder="Enter Full Name in Hindi" required>
                            @error('hindi_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Mother's Name -->
                        <div class="form-group col-md-6">
                            <label for="mother_name">Mother's Name</label>
                            <input type="text" name="mother_name"
                                class="form-control @error('mother_name') is-invalid @enderror" id="mother_name"
                                value="{{ old('mother_name', $registration->mother_name) }}"
                                placeholder="Enter Mother's Name" required>
                            @error('mother_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                         <!-- Mother's Name in Hindi -->
                         <div class="form-group col-md-6">
                            <label for="mother_name_hindi">Mother's Name (हिन्दी)</label>
                            <input type="text" name="mother_name_hindi"
                                class="form-control @error('mother_name_hindi') is-invalid @enderror" id="mother_name_hindi"
                                value="{{ old('mother_name_hindi', $registration->mother_name_hindi) }}" placeholder="Enter Mother's Name in Hindi" required>
                            @error('mother_name_hindi')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Father's Name -->
                        <div class="form-group col-md-6">
                            <label for="father_name">Father's Name</label>
                            <input type="text" name="father_name"
                                class="form-control @error('father_name') is-invalid @enderror" id="father_name"
                                value="{{ old('father_name', $registration->father_name) }}"
                                placeholder="Enter Father's Name" required>
                            @error('father_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                         <!-- Father's Name in Hindi -->
                         <div class="form-group col-md-6">
                            <label for="father_name_hindi">Father's Name (हिन्दी)</label>
                            <input type="text" name="father_name_hindi"
                                class="form-control @error('father_name_hindi') is-invalid @enderror" id="father_name_hindi"
                                value="{{ old('father_name_hindi', $registration->father_name_hindi) }}" placeholder="Enter Father's Name in Hindi" required>
                            @error('father_name_hindi')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Date of Birth -->
                        <div class="form-group col-md-6">
                            <label for="dob">Date of Birth</label>
                            <input type="date" name="date_of_birth"
                                class="form-control @error('date_of_birth') is-invalid @enderror" id="date_of_birth"
                                value="{{ old('date_of_birth', $registration->date_of_birth) }}"
                                placeholder="Enter Date of Birth" required>
                            @error('date_of_birth')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- Village -->
                        <div class="form-group col-md-6">
                            <label for="village">Village</label>
                            <input type="text" name="village" class="form-control @error('village') is-invalid @enderror"
                                id="village" value="{{ old('village', $registration->village) }}"
                                placeholder="Enter Village Name" required>
                            @error('village')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Police Station -->
                        <div class="form-group col-md-6">
                            <label for="police_station">Police Station</label>
                            <input type="text" name="police_station"
                                class="form-control @error('police_station') is-invalid @enderror" id="police_station"
                                value="{{ old('police_station', $registration->police_station) }}"
                                placeholder="Enter Police Station Name" required>
                            @error('police_station')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <!-- State -->
                        <div class="form-group col-md-6">
                            <label for="state">State</label>
                            <select id="IndiaStates" name="state_id"
                                class="form-control select2 @error('state') is-invalid @enderror">
                            </select>
                            @error('state_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>


                        <!-- District -->
                        <div class="form-group col-md-6">
                            <label for="Districts">District</label>
                            <select id="Districts" name="district_id" data-placeholder="Please Select an Option"
                                class="form-control select2 @error('district') is-invalid @enderror">
                                @if ($registration->state)
                                    @foreach ($registration->state['districts'] as $district)
                                        <option value="{{ $district['id'] }}"
                                            {{ old('district', $registration->district_id) == $district['id'] ? 'selected' : '' }}>
                                            {{ $district['name'] }}</option>
                                    @endforeach
                                @endif
                            </select>
                            @error('district_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Block -->
                        <div class="form-group col-md-6">
                            <label for="block">Block</label>
                            <input type="text" name="block" class="form-control @error('block') is-invalid @enderror"
                                id="block" value="{{ old('block', $registration->block) }}"
                                placeholder="Enter Block Name" required>
                            @error('block')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Mobile Number -->
                        <div class="form-group col-md-6">
                            <label for="mobile_number">Mobile Number</label>
                            <input type="text" name="mobile_number"
                                class="form-control @error('mobile_number') is-invalid @enderror" id="mobile_number"
                                value="{{ old('mobile_number', $registration->mobile_number) }}"
                                placeholder="+91 99999 99999" required>
                            @error('mobile_number')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Email -->
                        <div class="form-group col-md-6">
                            <label for="email">Email</label>
                            <input type="email" name="email"
                                class="form-control @error('email') is-invalid @enderror" id="email"
                                value="{{ old('email', $registration->email) }}" placeholder="Enter Email Address"
                                required>
                            @error('email')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Photo -->
                        <div class="form-group col-md-6">
                            <label for="photo">Photo</label>
                            <input type="file" name="photo"
                                class="form-control @error('photo') is-invalid @enderror" id="photo"
                                accept="image/*">
                            @if ($registration->photo)
                                <a href="{{ asset('storage/' . $registration->photo) }}" target="_blank"
                                    class="btn btn-sm btn-info mt-1">View Current Photo</a>
                            @endif
                            @error('photo')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Signature -->
                        <div class="form-group col-md-6">
                            <label for="signature">Signature</label>
                            <input type="file" name="signature"
                                class="form-control @error('signature') is-invalid @enderror" id="signature"
                                accept="image/*">
                            @if ($registration->signature)
                                <a href="{{ asset('storage/' . $registration->signature) }}" target="_blank"
                                    class="btn btn-sm btn-info mt-1">View Current Signature</a>
                            @endif
                            @error('signature')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Date -->
                        <div class="form-group col-md-6">
                            <label for="date">Date</label>
                            <input type="date" name="date"
                                class="form-control @error('date') is-invalid @enderror" id="date"
                                value="{{ old('date', $registration->date) }}">
                            @error('date')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                    <!-- Postal Code -->
                    <div class="form-group col-md-6">
                        <label for="postal_code">Postal Code</label>
                        <input type="number" name="postal_code"
                            class="form-control @error('postal_code') is-invalid @enderror" id="postal_code"
                            value="{{ old('postal_code', $registration->postal_code) }}" placeholder="Enter Postal Code">
                        @error('postal_code')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <!--Adhar Card Front -->
                    <div class="form-group col-md-6">
                        <label for="image">Adhar Card (Front)</label>
                        <input type="file" name="adhar_card_front"
                            class="form-control @error('adhar_card_front') is-invalid @enderror" id="adhar_card_front"
                            value="{{ old('adhar_card_front', $registration->adhar_card_front) }}">
                            @if ($registration->adhar_card_front)
                            <a href="{{ asset('storage/' . $registration->adhar_card_front) }}" target="_blank"
                                class="btn btn-sm btn-info mt-1">View Current Photo</a>
                        @endif
                        @error('adhar_card_front')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <!--Adhar Card -->
                    <div class="form-group col-md-6">
                        <label for="image">Adhar Card (Back)</label>
                        <input type="file" name="adhar_card_back"
                            class="form-control @error('adhar_card_back') is-invalid @enderror" id="adhar_card_back"
                            value="{{ old('adhar_card_back', $registration->adhar_card_back) }}">
                            @if ($registration->adhar_card_back)
                            <a href="{{ asset('storage/' . $registration->adhar_card_back) }}" target="_blank"
                                class="btn btn-sm btn-info mt-1">View Current Photo</a>
                        @endif
                        @error('adhar_card_back')
                            <div class="text-danger">{{ $message }}</div>
                        @enderror
                    </div>

                        <!-- Educational Qualifications -->
                        <div class="form-group col-md-12">
                            <label for="educational_qualifications">Educational Qualifications</label>
                            <textarea name="educational_qualifications"
                                class="form-control @error('educational_qualifications') is-invalid @enderror" id="educational_qualifications"
                                placeholder="Enter Educational Qualifications" required>{{ old('educational_qualifications', $registration->educational_qualifications) }}</textarea>
                            @error('educational_qualifications')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('registrations.index') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Update Registration</button>
                    </div>
                </div>

            </form>
        </div>
    </div>

@endsection
@push('scripts')
    @include('admin.pdcr._scripts')

    <script>
        @if (old('state_id'))
            var state = @json(App\Models\State::find(old('state_id')));
            $('#IndiaStates').append(
                '<option value="' + state.id + '" selected>' + state.name + '</option>').trigger('change');
        @elseif ($registration->state_id)
            var state = @json(App\Models\State::find($registration->state_id));
            $('#IndiaStates').append(
                '<option value="' + state.id + '" selected>' + state.name + '</option>').trigger('change');
        @endif
        @if (old('district_id'))
            var district = @json(App\Models\District::find(old('district_id')));
            $('#Districts').append(
                '<option value="' + district.id + '" selected>' + district.name + '</option>').trigger('change');
        @endif
    </script>
@endpush
