@extends('layouts.app')
@section('page_title', 'District Search')

@section('content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">PDC Registrations</h3>
                <div>
                    @can('export_pdc_registration')
                        <a href="{{ route('pdcr.export') }}" class="btn btn-primary btn-sm" id="exportcsv"
                            onclick="event.preventDefault(); document.getElementById('exportForm').submit();">Export CSV</a>
                    @endcan

                    <a href="{{ route('pdcr.index') }}">
                        <button class="btn btn-primary btn-sm">Go Back</button>
                    </a>
                </div>
            </div>
            <div class="card-body table-responsive">
                <table id="datatable" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Reg-No</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Added By</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($registrations as $registration)
                            <tr>
                                <td>{{ $registration->reg_no }}</td>
                                <td>{{ $registration->name }}</td>
                                <td>{{ $registration->email }}</td>
                                <td>{{ $registration->mobile_number }}</td>
                                <td>{{ $registration->added_by }}</td>
                                <td>

                                    <a class="btn btn-primary btn-sm" data-bs-toggle="tooltip"
                                        title="Generate Certificate with Background"
                                        href="{{ route('pdcr.generate.certificate', [$registration->id, 'withbg' => true]) }}">
                                        <i class="fa fa-certificate"></i></a>

                                    <a class="btn btn-primary btn-sm" data-bs-toggle="tooltip"
                                        title="Generate Certificate without Background"
                                        href="{{ route('pdcr.generate.certificate', $registration->id) }}"> <i
                                            class="fa fa-certificate"></i></a>

                                    <a class="btn btn-success btn-sm" href="{{ route('pdcr.print', $registration->id) }}">
                                        <i class="fa fa-print"></i></a>

                                    <a class="btn btn-info btn-sm" href="{{ route('pdcr.view', $registration->id) }}">
                                        <i class="fa fa-eye"></i></a>

                                    <a class="btn btn-warning btn-sm" href="{{ route('pdcr.edit', $registration->id) }}">
                                        <i class="fas fa-pencil-alt"></i></a>

                                    <form id="delete-form-{{ $registration->id }}"
                                        action="{{ route('pdcr.delete', $registration->id) }}" method="POST"
                                        style="display: none;">
                                        @csrf
                                        @method('DELETE') <!-- This is necessary to simulate a DELETE request -->
                                    </form>
                                    <a href="#" class="btn btn-danger btn-sm"
                                        onclick="event.preventDefault(); document.getElementById('delete-form-{{ $registration->id }}').submit();"
                                        id="delete-btn-{{ $registration->id }}"><i class="far fa-trash-alt"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <form id="exportForm" action="{{ route('pdcr.district.csv.download') }}" method="POST">
        @csrf
        @isset(request()->state_id)
            <input type="hidden" name="state_id" value="{{ request()->state_id }}">
        @endisset
        @isset(request()->district_id)
            <input type="hidden" name="district_id" value="{{ request()->district_id }}">
        @endisset
    </form>
@endsection

@push('scripts')
    <!-- Include DataTables CSS and JS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#datatable').DataTable({
                responsive: true, // Makes the table responsive
                pageLength: 10, // Default number of rows
                lengthMenu: [5, 10, 25, 50], // Length menu options
            });
        });
    </script>
@endpush
