@extends('layouts.app')
@section('page_title', 'Add Teacher')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Add Teacher</h3>
                <div>
                    <a href="{{ route('bss.teachers.index') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('bss.teachers.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <!-- Name Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="mb-1">Teacher Name</label>
                                <input type="text" name="name"
                                    class="form-control @error('name') is-invalid @enderror" id="name"
                                    placeholder="Enter User Name" value="{{ old('name') }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Email Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email" class="mb-1">Teacher Email</label>
                                <input type="email" name="email"
                                    class="form-control @error('email') is-invalid @enderror" id="email"
                                    placeholder="Enter User Email" value="{{ old('email') }}" required>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Location Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="location" class="mb-1">Location</label>
                                <input type="text" name="location"
                                    class="form-control @error('location') is-invalid @enderror" id="location"
                                    placeholder="Enter User location" value="{{ old('location') }}" required>
                                @error('location')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Email Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="dob" class="mb-1">Date of Joining</label>
                                <input type="date" name="dob" class="form-control @error('dob') is-invalid @enderror"
                                    id="dob" placeholder="Enter User dob" value="{{ old('dob') }}" required>
                                @error('dob')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Phone Fields -->

                        <div class="form-group col-md-6">
                            <label for="phone_no">Mobile Number</label>
                            <input type="text" name="phone_no"
                                class="form-control  @error('phone_no') is-invalid @enderror" id="phone_no"
                                value="{{ old('phone_no') }}" placeholder="+91 99999 99999" required>
                            @error('phone_no')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('bss.teachers.index') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Create Teacher</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
          $(document).ready(function() {
        $('#phone_no').inputmask('+99 99999 99999');
    });
    </script>
@endpush
