@extends('layouts.app')
@section('page_title', $teacher->name . ' Attendance')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <div class="col-md-3">
                    <h3 class="card-title mr-auto">Teacher Attendance</h3>
                </div>
                <div class="col-md-6">
                    <!-- Date filter form -->
                    <div class="d-flex gap-3">
                        <form action="{{ route('bss.teachers.attendence.report', $teacher->id) }}" method="GET"
                            class="d-flex">
                            <div class="input-group input-group-sm mr-2">
                                <input type="date" name="date_from" value="{{ request('date_from') }}"
                                    class="form-control" />
                                <input type="date" name="date_to" value="{{ request('date_to') }}"
                                    class="form-control" />
                                <select name="search" class="form-control">
                                    <option value="">Select Status</option>
                                    <option value="absent" {{ request('search') == 'absent' ? 'selected' : '' }}>Absent
                                    </option>
                                    <option value="present" {{ request('search') == 'present' ? 'selected' : '' }}>Present
                                    </option>
                                    <option value="busy" {{ request('search') == 'busy' ? 'selected' : '' }}>Busy</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary btn-sm">Filter</button>
                        </form>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="d-flex justify-content-end gap-1">
                        {{-- <a href="{{ route('bss.teachers.attendence.exportCSV', $teacher->id) }}"
                            class="btn btn-primary btn-sm">Export CSV</a> --}}
                        <button type="button" class="btn btn-primary btn-sm"
                            onclick="document.getElementById('export_CSV_FORM').submit();">Export CSV</button>
                        <a href="{{ route('bss.teachers.index') }}" class="btn btn-warning btn-sm ml-1">Go Back</a>
                    </div>
                </div>
            </div>
            <form action="{{ route('bss.teachers.attendence.exportCSV', $teacher->id) }}" id="export_CSV_FORM"
                style="display: none">
                <div class="input-group input-group-sm mr-2">
                    <input type="date" name="date_from" value="{{ request('date_from') }}" class="form-control" />
                    <input type="date" name="date_to" value="{{ request('date_to') }}" class="form-control" />
                    <input type="text" name="search" placeholder="Search Attendance Status"
                        value="{{ request('search') }}" class="form-control" />
                </div>
            </form>

            <form action="{{ route('bss.teachers.attendence.store') }}" method="POST">
                @csrf
                <div class="card-body">
                    <div>
                        <h6><span>Records Found:</span>{{ $attendances->total() }}</h6>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Day</th>
                                    <th>Attendance Status</th>
                                    <th>Review</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($attendances as $attendance)
                                    <tr>
                                        <td>{{ $attendance->created_at ? $attendance->created_at->format('Y-m-d') : 'N/A' }}
                                        </td>
                                        <td>{{ $attendance->created_at ? $attendance->created_at->format('l') : 'N/A' }}</td>
                                        <td>
                                            @if ($attendance->attendance_status)
                                                {{ ucfirst($attendance->attendance_status) }}
                                            @else
                                                <span class="text-muted">No Status</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ $attendance->review ?? 'No review provided' }}
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No records found</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
            </form>

            <!-- Pagination Links -->
            <div class="card-footer">
                <div class="d-flex justify-content-between">
                    <div></div>
                    <div>
                        {{ $attendances->appends($_GET)->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
