@extends('layouts.app')
@section('page_title', 'Teacher Attendance')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Teacher Attendance</h3>
                <div>
                    <a href="{{ route('bss.teachers.index') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('bss.teachers.attendence.store') }}" method="POST">
                @csrf
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Teacher Name</th>
                                    <th>Attendance</th>
                                    <th>Review</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($teachers as $teacher)
                                    @php
                                        $attendance = $teacher->teacher_attandances->first();
                                    @endphp
                                    <tr>
                                        <td>
                                            {{ $teacher->name }}
                                            <input type="hidden" name="teacher_id[]" value="{{ $teacher->id }}">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center" style="gap: 5px;">
                                                <input type="radio" id="present-{{ $teacher->id }}"
                                                    name="attendance[{{ $teacher->id }}]" value="present"
                                                    {{ ($attendance && $attendance->attendance_status === 'present') ?  'checked' : '' }}>
                                                <label for="present-{{ $teacher->id }}">Present</label>

                                                <input type="radio" id="absent-{{ $teacher->id }}"
                                                    name="attendance[{{ $teacher->id }}]" value="absent"
                                                    {{ $attendance && $attendance->attendance_status === 'absent' ? 'checked' : '' }}>
                                                <label for="absent-{{ $teacher->id }}">Absent</label>

                                                <input type="radio" id="busy-{{ $teacher->id }}"
                                                    name="attendance[{{ $teacher->id }}]" value="busy"
                                                    {{ $attendance && $attendance->attendance_status === 'busy' ? 'checked' : '' }}>
                                                <label for="busy-{{ $teacher->id }}">Busy</label>
                                            </div>
                                        </td>

                                        <td>
                                            <textarea name="review[{{ $teacher->id }}]" class="form-control" placeholder="Enter Review" rows="1">{{ $attendance->review ?? '' }}</textarea>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No records found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('bss.teachers.index') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Save Attendance</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
