@extends('layouts.app')
@section('page_title', 'Edit Student')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Edit Student</h3>
                <div>
                    <a href="{{ route('bss.students.index') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{route('bss.students.update',$bssStudent->id)}}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="row">
                        <!-- Student Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="mb-1">Student Name</label>
                                <input type="text" name="name"
                                    class="form-control @error('name') is-invalid @enderror" id="name"
                                    placeholder="Enter Student Name" value="{{ old('name',$bssStudent->name) }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Gender -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="gender" class="mb-1">Gender</label>
                                <select name="gender" id="gender"
                                    class="form-control @error('gender') is-invalid @enderror" required>
                                    <option value="" disabled selected>Select Gender</option>
                                    <option value="Male" {{ old('gender',$bssStudent->gender) == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ old('gender',$bssStudent->gender) == 'Female' ? 'selected' : '' }}>Female</option>
                                    <option value="Other" {{ old('gender',$bssStudent->gender) == 'Other' ? 'selected' : '' }}>Other</option>
                                </select>
                                @error('gender')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Class -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="class" class="mb-1">Class</label>
                                <select name="class" id="class"
                                    class="form-control @error('class') is-invalid @enderror" required>
                                    <option value="" disabled selected>Select Class</option>
                                    <option value="Class 1" {{ old('class',$bssStudent->class) == 'Class 1' ? 'selected' : '' }}>Class 1
                                    </option>
                                    <option value="Class 2" {{ old('class',$bssStudent->class) == 'Class 2' ? 'selected' : '' }}>Class 2
                                    </option>
                                    <option value="Class 3" {{ old('class',$bssStudent->class) == 'Class 3' ? 'selected' : '' }}>Class 3
                                    </option>
                                </select>
                                @error('class')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Category -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category" class="mb-1">Category</label>
                                <select name="category" id="category"
                                    class="form-control @error('category') is-invalid @enderror" required>
                                    <option value="" disabled selected>Select Category</option>
                                    <option value="General" {{ old('category') == 'General' ? 'selected' : '' }}>General
                                    </option>
                                    <option value="OBC" {{ old('category',$bssStudent->category) == 'OBC' ? 'selected' : '' }}>OBC</option>
                                    <option value="SC" {{ old('category',$bssStudent->category) == 'SC' ? 'selected' : '' }}>SC</option>
                                    <option value="ST" {{ old('category',$bssStudent->category) == 'ST' ? 'selected' : '' }}>ST</option>
                                </select>
                                @error('category')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Mobile Number -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mobile_number" class="mb-1">Mobile Number</label>
                                <input type="text" name="mobile_number"
                                    class="form-control @error('mobile_number') is-invalid @enderror" id="mobile_number"
                                    placeholder="Enter Mobile Number" value="{{ old('mobile_number',$bssStudent->mobile_number) }}" required>
                                @error('mobile_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Alternative Contact Number -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="alternative_contact_number" class="mb-1">Alternative Contact Number</label>
                                <input type="text" name="alternative_contact_number"
                                    class="form-control @error('alternative_contact_number') is-invalid @enderror"
                                    id="alternative_contact_number" placeholder="Enter Alternative Contact Number"
                                    value="{{ old('alternative_contact_number',$bssStudent->alternative_contact_number) }}">
                                @error('alternative_contact_number')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Date of Birth -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="dob" class="mb-1">Date of Birth</label>
                                <input type="date" name="dob" class="form-control @error('dob') is-invalid @enderror"
                                    id="dob" value="{{ old('dob',$bssStudent->dob) }}" required>
                                @error('dob')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="blood_group" class="mb-1">Blood Group</label>
                                <select name="blood_group" id="blood_group" class="form-control @error('blood_group') is-invalid @enderror" required>
                                    <option value="" disabled>Select Blood Group</option>
                                    <option value="A+" {{ old('blood_group', $bssStudent->blood_group) == 'A+' ? 'selected' : '' }}>A+</option>
                                    <option value="A-" {{ old('blood_group', $bssStudent->blood_group) == 'A-' ? 'selected' : '' }}>A-</option>
                                    <option value="B+" {{ old('blood_group', $bssStudent->blood_group) == 'B+' ? 'selected' : '' }}>B+</option>
                                    <option value="B-" {{ old('blood_group', $bssStudent->blood_group) == 'B-' ? 'selected' : '' }}>B-</option>
                                    <option value="O+" {{ old('blood_group', $bssStudent->blood_group) == 'O+' ? 'selected' : '' }}>O+</option>
                                    <option value="O-" {{ old('blood_group', $bssStudent->blood_group) == 'O-' ? 'selected' : '' }}>O-</option>
                                    <option value="AB+" {{ old('blood_group', $bssStudent->blood_group) == 'AB+' ? 'selected' : '' }}>AB+</option>
                                    <option value="AB-" {{ old('blood_group', $bssStudent->blood_group) == 'AB-' ? 'selected' : '' }}>AB-</option>
                                </select>
                                @error('blood_group')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Area of Residence -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="area_of_residence" class="mb-1">Area of Residence</label>
                                <input type="text" name="area_of_residence" class="form-control @error('area_of_residence') is-invalid @enderror"
                                    id="area_of_residence" placeholder="Enter Area of Residence" value="{{ old('area_of_residence', $bssStudent->area_of_residence) }}" required>
                                @error('area_of_residence')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Photograph -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="photograph" class="mb-1">Photograph</label>
                                <input type="file" name="photograph" class="form-control @error('photograph') is-invalid @enderror"
                                    id="photograph" accept="image/*">
                                    @if ($bssStudent->photograph)
                                    <a href="{{ asset('storage/' . $bssStudent->photograph) }}" class="btn btn-sm btn-primary mt-1" target="_blank">View Image</a>
                                @else
                                    <p>No photograph uploaded.</p>
                                @endif

                                @error('photograph')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Mother Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mother_name" class="mb-1">Mother Name</label>
                                <input type="text" name="mother_name" class="form-control @error('mother_name') is-invalid @enderror"
                                    id="mother_name" placeholder="Enter Mother's Name" value="{{ old('mother_name', $bssStudent->mother_name) }}" required>
                                @error('mother_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Mother Profession -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mother_profession" class="mb-1">Mother's Profession</label>
                                <input type="text" name="mother_profession" class="form-control @error('mother_profession') is-invalid @enderror"
                                    id="mother_profession" placeholder="Enter Mother's Profession" value="{{ old('mother_profession', $bssStudent->mother_profession) }}" required>
                                @error('mother_profession')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Father Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="father_name" class="mb-1">Father Name</label>
                                <input type="text" name="father_name" class="form-control @error('father_name') is-invalid @enderror"
                                    id="father_name" placeholder="Enter Father's Name" value="{{ old('father_name', $bssStudent->father_name) }}" required>
                                @error('father_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Father Profession -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="father_profession" class="mb-1">Father's Profession</label>
                                <input type="text" name="father_profession" class="form-control @error('father_profession') is-invalid @enderror"
                                    id="father_profession" placeholder="Enter Father's Profession" value="{{ old('father_profession', $bssStudent->father_profession) }}" required>
                                @error('father_profession')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Years of Association with BSS -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="years_of_association_with_bss" class="mb-1">Years of Association with BSS</label>
                                <input type="number" name="years_of_association_with_bss"
                                    class="form-control @error('years_of_association_with_bss') is-invalid @enderror"
                                    id="years_of_association_with_bss" placeholder="Enter Years of Association with BSS"
                                    value="{{ old('years_of_association_with_bss', $bssStudent->years_of_association_with_bss) }}" required>
                                @error('years_of_association_with_bss')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>


                        <!-- Family Association with Gayatri Pariwar -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="family_association_with_gayatri_pariwar" class="mb-1">Family Association with Gayatri Pariwar</label>
                                <select name="family_association_with_gayatri_pariwar"
                                    class="form-control @error('family_association_with_gayatri_pariwar') is-invalid @enderror"
                                    id="family_association_with_gayatri_pariwar" required>
                                    <option value="" disabled selected>Select an option</option>
                                    <option value="Yes" {{ old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'Yes' ? 'selected' : '' }}>Yes</option>
                                    <option value="No" {{ old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'No' ? 'selected' : '' }}>No</option>
                                    <option value="Maybe" {{ old('family_association_with_gayatri_pariwar',$bssStudent->family_association_with_gayatri_pariwar) == 'Maybe' ? 'selected' : '' }}>Maybe</option>
                                </select>
                                @error('family_association_with_gayatri_pariwar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- School Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="school_name" class="mb-1">School Name</label>
                                <input type="text" name="school_name" class="form-control @error('school_name') is-invalid @enderror"
                                    id="school_name" placeholder="Enter School Name" value="{{ old('school_name', $bssStudent->school_name) }}" required>
                                @error('school_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- School Address -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="school_address" class="mb-1">School Address</label>
                                <textarea name="school_address" class="form-control @error('school_address') is-invalid @enderror"
                                    id="school_address" placeholder="Enter School Address" rows="3" required>{{ old('school_address', $bssStudent->school_address) }}</textarea>
                                @error('school_address')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>



                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('bss.students.index') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Update student</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function() {
            $('#mobile_number').inputmask('+99 99999 99999');
        });
        $(document).ready(function() {
            $('#alternative_contact_number').inputmask('+99 99999 99999');
        });
    </script>
@endpush
