@extends('layouts.app')
@section('page_title', 'Student Attendance')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Student Attendance</h3>
                <div>
                    <a href="{{ route('bss.students.index') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('bss.students.attendence.store') }}" method="POST">
                @csrf
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Student Name</th>
                                    <th>Attendance</th>
                                    <th>Review</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($students as $student)
                                    @php
                                        $attendance = $student->student_attandances->first();
                                    @endphp
                                    <tr>
                                        <td>
                                            {{ $student->name }}
                                            <input type="hidden" name="student_id[]" value="{{ $student->id }}">
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center" style="gap: 5px;">
                                                <input type="radio" id="present-{{ $student->id }}"
                                                    name="attendance[{{ $student->id }}]" value="present"
                                                    {{ ($attendance && $attendance->attendance_status === 'present') ?  'checked' : '' }}>
                                                <label for="present-{{ $student->id }}">Present</label>

                                                <input type="radio" id="absent-{{ $student->id }}"
                                                    name="attendance[{{ $student->id }}]" value="absent"
                                                    {{ $attendance && $attendance->attendance_status === 'absent' ? 'checked' : '' }}>
                                                <label for="absent-{{ $student->id }}">Absent</label>

                                                <input type="radio" id="busy-{{ $student->id }}"
                                                    name="attendance[{{ $student->id }}]" value="busy"
                                                    {{ $attendance && $attendance->attendance_status === 'busy' ? 'checked' : '' }}>
                                                <label for="busy-{{ $student->id }}">Busy</label>
                                            </div>
                                        </td>

                                        <td>
                                            <textarea name="review[{{ $student->id }}]" class="form-control" placeholder="Enter Review" rows="1">{{ $attendance->review ?? '' }}</textarea>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No records found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('bss.students.index') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Save Attendance</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
