@extends('layouts.app')
@section('page_title', 'Upload File')
@push('styles')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" rel="stylesheet">
    <style>
        #image-preview-container {
            max-width: 100%;
            overflow: hidden;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 5px;
            margin-top: 10px;
        }

        #image-buttons {
            display: flex;
            align-items: center;
            gap: 10px;
            justify-content: center
        }
    </style>
@endpush
@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Upload File</h3>
                <div>
                    <a href="{{ route('bss.shared.files') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>
            <form action="{{ route('bss.shared.files.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="card-body">
                    <div class="row">
                        <!-- File Name Field -->
                        <div class="col-md-6 mt-2">
                            <div class="form-group">
                                <label for="file_name" class="mb-1">File Name</label>
                                <input type="text" name="file_name" id="file_name"
                                    class="form-control @error('file_name') is-invalid @enderror"
                                    placeholder="Enter File Name" value="{{ old('file_name') }}" required>
                                @error('file_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <!-- Visibility Field -->
                        <div class="col-md-6 mt-2">
                            <div class="form-group">
                                <label for="visibility" class="mb-1">Visibility</label>
                                <select name="visibility" id="visibility"
                                    class="form-control @error('visibility') is-invalid @enderror">
                                    <option value="" disabled selected>Select Visibility</option>
                                    <option value="public" {{ old('visibility') == 'public' ? 'selected' : '' }}>Public
                                    </option>
                                    <option value="private" {{ old('visibility') == 'private' ? 'selected' : '' }}>Private
                                    </option>
                                </select>
                                @error('visibility')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 mt-2">
                            <div class="form-group">
                                <label for="Image" class="mb-1">Image</label>
                                <input type="file" name="Image" id="Image"
                                    class="form-control @error('Image') is-invalid @enderror">
                                <div id="image-preview-container" class="mt-2" style="display: none;">
                                    <img id="image-preview" style="width: 100%; height: auto;">
                                </div>
                                <div id="image-buttons" class="mt-2" style="display: none;">
                                    <button type="button" id="select-image" class="btn btn-success btn-sm">Select
                                        Image</button>
                                    <button type="button" id="remove-image" class="btn btn-danger btn-sm">Remove
                                        Image</button>
                                </div>
                                @error('Image')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <input type="hidden" name="cropped_image" id="cropped_image">



                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end" style="gap: 0.3rem">
                        <a href="{{ route('bss.shared.files') }}" class="btn btn-secondary btn-sm">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Upload File</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const ImageInput = document.getElementById('Image');
            const imagePreviewContainer = document.getElementById('image-preview-container');
            const imagePreview = document.getElementById('image-preview');
            const croppedImageInput = document.getElementById('cropped_image');
            const imageButtons = document.getElementById('image-buttons');
            const selectImageButton = document.getElementById('select-image');
            const removeImageButton = document.getElementById('remove-image');
            let cropper;

            // Handle file input changes
            ImageInput.addEventListener('change', function(e) {
                const file = e.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(event) {
                        imagePreview.src = event.target.result;
                        imagePreviewContainer.style.display = 'block';
                        imageButtons.style.display = 'flex'; // Show the buttons

                        // Initialize Cropper.js
                        if (cropper) {
                            cropper.destroy(); // Destroy previous cropper instance
                        }
                        cropper = new Cropper(imagePreview, {
                            aspectRatio: 1, // Set aspect ratio (e.g., 1 for square)
                            viewMode: 1,
                            autoCropArea: 1,
                        });
                    };
                    reader.readAsDataURL(file);
                    selectImageButton.style.display = 'block';
                }
            });

            // Handle Select Image button click
            selectImageButton.addEventListener('click', function() {
                if (cropper) {
                    cropper.getCroppedCanvas().toBlob(function(blob) {
                        const reader = new FileReader();
                        reader.onloadend = function() {
                            croppedImageInput.value = reader
                                .result; // Set base64 cropped image to hidden input
                            imagePreview.src = reader
                                .result; // Display the cropped image in the preview
                            cropper.destroy(); // Destroy the cropper instance
                            cropper = null;
                        };
                        reader.readAsDataURL(blob);
                    });
                    selectImageButton.style.display = 'none';
                }
            });

            // Handle Remove Image button click
            removeImageButton.addEventListener('click', function() {
                ImageInput.value = ''; // Clear the file input
                croppedImageInput.value = ''; // Clear the hidden input
                imagePreviewContainer.style.display = 'none'; // Hide the image preview container
                imageButtons.style.display = 'none'; // Hide the buttons
                if (cropper) {
                    cropper.destroy(); // Destroy the cropper instance
                    cropper = null;
                }
            });
        });
    </script>
@endpush
