@extends('layouts.app')
@section('page_title', 'Edit BSS')

@section('content')
    <div class="container">
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center">
                <h3 class="card-title mr-auto">Edit BSS</h3>
                <div>
                    <a href="{{ route('bss') }}" class="btn btn-warning btn-sm float-end">Go Back</a>
                </div>
            </div>

            <form action="{{ route('bss.update', $bss->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="card-body">
                    <div class="row">

                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <label for="bss_name" class="mb-1">BSS Name</label>
                                <textarea name="bss_name" id="bss_name" class="form-control @error('bss_name') is-invalid @enderror"
                                    placeholder="Enter BSS Name" required>{{ old('bss_name', $bss->bss_name) }}</textarea>
                                @error('bss_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- BSS Place Field -->
                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <label for="bss_place" class="mb-1">BSS Place</label>
                                <textarea name="bss_place" id="bss_place" class="form-control @error('bss_place') is-invalid @enderror"
                                    placeholder="Enter BSS Place" required>{{ old('bss_place', $bss->bss_place) }}</textarea>
                                @error('bss_place')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Registration No Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="registration_no" class="mb-1">Registration Number</label>
                                <input type="text" name="registration_no"
                                    class="form-control @error('registration_no') is-invalid @enderror" id="registration_no"
                                    placeholder="Enter Registration Number"
                                    value="{{ old('registration_no', $bss->registration_no) }}" required>
                                @error('registration_no')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>



                        <!-- Teacher Name Field -->
                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <label for="teacher_name" class="mb-1">Teacher Name</label>
                                <input type="text" name="teacher_name"
                                    class="form-control @error('teacher_name') is-invalid @enderror" id="teacher_name"
                                    placeholder="Enter Teacher Name" value="{{ old('teacher_name', $bss->teacher_name) }}"
                                    required>
                                @error('teacher_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Teacher Contact No Field -->
                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <label for="teacher_contact_no" class="mb-1">Teacher Contact No</label>
                                <input type="text" name="teacher_contact_no"
                                    class="form-control @error('teacher_contact_no') is-invalid @enderror"
                                    id="teacher_contact_no" placeholder="+91 99999 99999"
                                    value="{{ old('teacher_contact_no', $bss->teacher_contact_no) }}" required>
                                @error('teacher_contact_no')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <!-- Name Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="mb-1">User Name</label>
                                <input type="text" name="name"
                                    class="form-control @error('name') is-invalid @enderror" id="name"
                                    placeholder="Enter User Name" value="{{ old('name', $user->name) }}" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Email Field -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email" class="mb-1">Email</label>
                                <input type="email" name="email" disabled
                                    class="form-control @error('email') is-invalid @enderror" id="email"
                                    placeholder="Enter User Email" value="{{ old('email', $user->email) }}" required>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- User Image Field -->
                        <div class="col-md-6 mt-1">
                            <div class="form-group">
                                <label for="avatar" class="mb-1">Image/Avatar</label>
                                <input type="file" name="avatar"
                                    class="form-control @error('avatar') is-invalid @enderror" id="image">
                                @error('avatar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            @if ($user->avatar)
                                <a href="{{ asset('storage/' . $user->avatar) }}" class="btn btn-sm btn-primary"
                                    target="_blank">View Image/Avatar</a>
                            @endif
                        </div>


                        <!-- Password Fields -->
                        <div class="col-md-6 mt-1">
                            <label for="password" class="mb-1">Password</label>
                            <input type="password" name="password"
                                class="form-control @error('password') is-invalid @enderror" id="password"
                                placeholder="Enter Password">
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mt-1">
                            <label for="password_confirmation" class="mb-1">Confirm Password</label>
                            <input type="password" name="password_confirmation"
                                class="form-control @error('password_confirmation') is-invalid @enderror"
                                id="password_confirmation" placeholder="Confirm Password">
                            @error('password_confirmation')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6 mt-2">
                            <label for="status" class="mb-1">Status</label>
                            <div class="d-flex align-items-center">
                                <label class="me-3">
                                    <input type="radio" name="status" value="active"
                                        {{ old('status') == 'active' ? 'checked' : '' }}> Active
                                </label>
                                <label>
                                    <input type="radio" name="status" value="inactive"
                                        {{ old('status') == 'inactive' ? 'checked' : '' }}> Inactive
                                </label>
                            </div>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>




                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-end gap-1">
                        <a href="{{ route('bss') }}" class="btn btn-secondary btn-sm mr-1">Cancel</a>
                        <button type="submit" class="btn btn-primary btn-sm">Update BSS</button>
                    </div>
                </div>
            </form>

        </div>
    </div>
@endsection
