$(document).ready(function () {
    // Set up AJAX to include CSRF token
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    function DarkMode() {
        var icon = $("#darkModeToggle i");
        var isDarkMode;

        // Toggle dark mode classes and set isDarkMode variable
        if (icon.hasClass("fa-sun")) {
            icon.removeClass("fa-sun").addClass("fa-moon");
            $("#mainNavbar").removeClass("navbar-dark").addClass("navbar-white navbar-light");
            $("body").removeClass("dark-mode");
            isDarkMode = 0;
        } else {
            icon.removeClass("fa-moon").addClass("fa-sun");
            $("#mainNavbar").addClass("navbar-dark").removeClass("navbar-white navbar-light");
            $("body").addClass("dark-mode");
            isDarkMode = 1;
        }

        // AJAX request to toggle dark mode
        $.ajax({
            url: ThemeToggleURL,
            method: "POST",
            data: {
                is_dark: isDarkMode
            },
            success: function (response) {
                console.log("Dark mode preference updated successfully.");
            },
            error: function (xhr) {
                console.log("An error occurred while updating the dark mode preference.");
            }
        });
    }

    // Bind the toggle function to the button
    $("#darkModeToggle").click(DarkMode);

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })


    $('.alert').each(function () {
        var $alert = $(this);
        setTimeout(function () {
            $alert.fadeOut('slow');
        }, 10000);
    });

    $('.select2').select2({
        theme: 'bootstrap4',
    });


    $('#IndiaStates').select2({
        theme: 'bootstrap4',
        placeholder: 'Select State of India',

        tokenSeparators: [','],
        ajax: {
            url: GetIndiaStatesURL,
            dataType: 'json',
            data: function (params) {
                let query = {
                    q: params.term,
                };
                return query;
            },
            processResults: function (data) {
                return {
                    results: data.map(function (item) {
                        return {
                            id: item.id,
                            text: item.name + (item.name_hindi ? ' (' + item.name_hindi + ')' : '')
                        };
                    })
                };
            },
            cache: true
        }
    });


    //SELECT CITIES BASED ON States SELECTED
    $('#IndiaStates').on('change', function () {
        var $state_id = $("#IndiaStates").val();
        $("#Districts").html("");

        $('#Districts').select2({
            theme: 'bootstrap4',
            placeholder: 'Select District of State',
            tokenSeparators: [','],

            ajax: {
                url: GetStateDestrictsURL,
                dataType: 'json',
                data: function (params) {
                    return {
                        c: $state_id,
                        q: params.term,
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id,
                                text: item.name + (item.name_hindi ? ' (' + item.name_hindi + ')' : '')
                            }
                        })
                    }
                },
                cache: true
            }
        });
    });


});

