<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $modules = getPermissions();
        $permissions = ['roles_and_permissions'];
        $bssPermission = ['manage_bss_settings', 'view_dashboard'];
        foreach ($modules as $modulePermissions) {
            $permissions = array_merge($permissions, array_keys($modulePermissions));
        }

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }
        foreach ($bssPermission as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }
        // Create roles if they don't already exist
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $userRole = Role::firstOrCreate(['name' => 'user']);
        $superAdminRole = Role::firstOrCreate(['name' => 'super-admin']);
        $bssRole = Role::firstOrCreate(['name' => 'bss_admin']);

        // Filter permissions for admin (excluding 'roles_and_permissions')
        $adminPermissions = array_filter($permissions, fn($perm) => $perm !== 'roles_and_permissions');
        $adminRole->syncPermissions($adminPermissions);

        // Filter permissions for user (only 'view_dashboard')
        $userPermissions = array_filter($permissions, fn($perm) => $perm === 'view_dashboard');
        $userRole->syncPermissions($userPermissions);

        // Super-admin gets all permissions
        $superAdminRole->syncPermissions($permissions);
        $bssRole->syncPermissions($bssPermission);
        // Create or retrieve the user and assign the super-admin role
        $user = User::firstOrCreate(
            ['email' => 'admin@gmail.com'],
            [
                'name' => 'User',
                'password' => Hash::make('123456789'),
                'email_verified_at' => now(),
                'active' => 1,
            ]
        );

        $user->assignRole($superAdminRole);
    }
}
