<?php

namespace Database\Seeders;

use App\Models\Country;
use App\Models\District;
use App\Models\State;
use Illuminate\Database\Seeder;

class IndiaStateDistrictSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Load the JSON file
        $jsonPath = storage_path('app/states-and-districts.json');
        $biharJSONPath = storage_path('app/bihar_state_districts.json');

        if (file_exists($jsonPath)) {
            $json = file_get_contents($jsonPath);
            $data = json_decode($json, true);

            // First, create the country "India"
            $india = Country::firstOrCreate([
                'name' => 'India',
                'country_code' => 91,
                'capital' => 'New Delhi',
                'latitude' => '20.00000000',
                'longitude' => '77.00000000',
            ]);

            if ($india) {

                foreach ($data['states'] as $stateData) {

                    $state = State::firstOrCreate([
                        'name' => $stateData['state'],
                        'country_id' => $india->id,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    if ($state->name == 'Bihar') {
                        $state->name_hindi = 'बिहार';
                        $state->save();

                        if (file_exists($biharJSONPath)) {
                            $biharJson = file_get_contents($biharJSONPath);
                            $biharJsonData = json_decode($biharJson, true);

                            $districts = [];
                            foreach ($biharJsonData['states'][0]['districts'] as $districtData) {

                                $districts[] = [
                                    'name' => $districtData['district'],
                                    'name_hindi' => $districtData['district_hindi'],
                                    'state_id' => $state->id,
                                    'created_at' => now(),
                                    'updated_at' => now(),
                                ];
                            }
                            District::insert($districts);
                        }
                    } else {
                        // For other states, save districts without Hindi translation
                        $districts = [];
                        foreach ($stateData['districts'] as $districtName) {
                            $districts[] = [
                                'name' => $districtName,
                                'state_id' => $state->id,
                                'created_at' => now(),
                                'updated_at' => now(),
                            ];
                        }

                        // Insert districts into the database
                        District::insert($districts);
                    }
                }
            }

            $this->command->info("All states and districts for India, including Bihar, have been seeded successfully.");
        } else {
            $this->command->error('JSON file not found!');
        }
    }
}
