<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Country;
use App\Models\State;
use App\Models\District;
use Illuminate\Support\Facades\File;

class CountriesStatesAndDistrictSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Load the JSON file
        $jsonPath = storage_path('app/countries_states_cities.json');

        if (file_exists($jsonPath)) {
            $json = file_get_contents($jsonPath);
            $data = json_decode($json, true);

            foreach ($data as $countryData) {
                Country::firstOrCreate([
                    'name' => $countryData['name'],
                    'country_code' => $countryData['phone_code'],
                    'capital' => $countryData['capital'],
                    'latitude' => $countryData['latitude'],
                    'longitude' => $countryData['longitude'],
                ]);
            }
            $india = Country::where('name', 'India')->first();
            // if ($india) {
            //     foreach ($data as $countryData) {
            //         if ($countryData['name'] === 'India') {
            //             foreach ($countryData['states'] as $stateData) {
            //                 $state = State::firstOrCreate([
            //                     'name' => $stateData['name'],
            //                     'state_code' => $stateData['state_code'],
            //                     'latitude' => $stateData['latitude'],
            //                     'longitude' => $stateData['longitude'],
            //                     'country_id' => $india->id,
            //                 ]);
            //                 $cities = [];
            //                 foreach ($stateData['cities'] as $cityData) {
            //                     $cities[] = [
            //                         'name' => $cityData['name'],
            //                         'latitude' => $cityData['latitude'],
            //                         'longitude' => $cityData['longitude'],
            //                         'state_id' => $state->id,
            //                         'created_at' => now(),
            //                         'updated_at' => now(),
            //                     ];
            //                 }
            //                 District::insert($cities);
            //             }
            //         }
            //     }
            // }

            $this->command->info("All countries have been seeded successfully.");
        } else {
            $this->command->error('JSON file not found!');
        }
    }
}
