<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bss_students', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('bss_id');
            $table->foreign('bss_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('name');
            $table->string('gender');
            $table->string('class');
            $table->string('category')->nullable();
            $table->string('school_name');
            $table->text('school_address')->nullable();
            $table->string('mobile_number');
            $table->string('alternative_contact_number')->nullable();
            $table->date('dob');
            $table->string('blood_group')->nullable();
            $table->string('area_of_residence')->nullable();
            $table->string('father_name');
            $table->string('mother_name');
            $table->string('mother_profession')->nullable();
            $table->string('father_profession')->nullable();
            $table->integer('years_of_association_with_bss')->nullable();
            $table->string('family_association_with_gayatri_pariwar')->nullable();
            $table->string('photograph')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bss_students');
    }
};
