<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pdc_registrations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('reg_no', 15)->unique();
            $table->string('certificate_no',15)->unique()->nullable();
            $table->string('name')->nullable();
            $table->string('hindi_name')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('mother_name_hindi')->nullable();
            $table->string('father_name')->nullable();
            $table->string('father_name_hindi')->nullable();
            $table->string('village')->nullable();
            $table->string('police_station')->nullable();
            $table->foreignId('state_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('district_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('block')->nullable();
            $table->string('mobile_number')->unique();
            $table->string('email')->unique();
            $table->string('educational_qualifications')->nullable();
            $table->string('photo')->nullable();
            $table->string('signature')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('adhar_card_front')->nullable();
            $table->string('adhar_card_back')->nullable();
            $table->date('date')->nullable();
            $table->string('status')->default('1');
            $table->enum('added_by', ['web', 'admin'])->default('web');
            $table->tinyInteger('certificate_status')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pdc_registrations');
    }
};
