<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Registration extends Model
{
    protected $fillable = [
        'user_id',
        'reg_no',
        'name',
        'father_name',
        'mother_name',
        'village',
        'police_station',
        'block',
        'district_id',
        'state_id',
        'mobile_number',
        'email',
        'educational_qualifications',
        'photo',
        'signature',
        'date',
        'date_of_birth',
        'added_by',
        'postal_code',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}
