<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PDCRegistration extends Model
{
    protected $table = "pdc_registrations";

    protected $fillable = [
        'user_id',
        'reg_no',
        'name',
        'hindi_name',
        'father_name',
        'father_name_hindi',
        'mother_name',
        'mother_name_hindi',
        'village',
        'police_station',
        'block',
        'district_id',
        'state_id',
        'mobile_number',
        'email',
        'educational_qualifications',
        'photo',
        'signature',
        'date',
        'date_of_birth',
        'added_by',
        'adhar_card_back',
        'adhar_card_front',
        'postal_code',
    ];
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}
