<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BssStudent extends Model
{
    protected $fillable = [
        'bss_id',
        'name',
        'gender',
        'class',
        'category',
        'school_name',
        'school_address',
        'mobile_number',
        'alternative_contact_number',
        'dob',
        'blood_group',
        'area_of_residence',
        'father_name',
        'mother_name',
        'mother_profession',
        'father_profession',
        'years_of_association_with_bss',
        'family_association_with_gayatri_pariwar',
        'photograph',
    ];

    public function student_attandances()
    {
        return $this->hasMany(BSSStudentAttendance::class, 'bss_student_id');
    }

}
