<?php

namespace App\Jobs;

use App\Models\FileManager;
use App\Models\UploadFile;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Storage;

class UploadFileToServer implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $localPath;
    protected $name;
    protected $destinationPath;

    public function __construct($localPath, $name, $destinationPath)
    {
        $this->localPath = $localPath;
        $this->name = $name;
        $this->destinationPath = $destinationPath;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // Read the file contents
        $fileContents = Storage::get($this->localPath);

        // Upload the file to the server
        Storage::disk('storage')->put("{$this->destinationPath}/{$this->name}", $fileContents);

        // Update the file record in the database
        $file = FileManager::where('path', $this->localPath)->first();
        if ($file) {
            $file->server_bit = 1;
            $file->save();
        }

        // Delete the file from local storage
        Storage::delete($this->localPath);

        // Check if the directory is empty and delete it if necessary
        $directory = dirname($this->localPath);
        $filesInDirectory = Storage::files($directory);
        if (empty($filesInDirectory)) {
            Storage::deleteDirectory($directory);
        }
    }
}
