<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Registration;
use Illuminate\Http\Request;

class RegistrationController extends Controller
{
    public function register()
    {
        return view('front.registrations.register');
    }

    public function storeRegistration(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'father_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'village' => 'required|string|max:255',
            'police_station' => 'required|string|max:255',
            'block' => 'required|string|max:255',
            'district_id' => 'required|exists:districts,id',
            'state_id' => 'required|exists:states,id',
            'mobile_number' => [
                'required',
                'string',
                'regex:/^\+91\s\d{5}\s\d{5}$/',
                'unique:registrations',
            ],
            // 'mobile_number' => 'required|string|max:255|unique:registrations',
            'email' => 'required|email|unique:registrations|string|max:255',
            'educational_qualifications' => 'required|string|max:255',
            'photo' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'signature' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'date' => 'nullable|date',
            'date_of_birth' => 'required|date',
            'postal_code' => 'nullable|numeric',
        ]);

        // $mobile_number = str_replace(['-', '_'], '', $request->input('mobile_number'));
        $mobile_number = $request->input('mobile_number');
        $registrationNumber = registrationNumber();
        while (Registration::where('reg_no', $registrationNumber)->exists()) {
            $registrationNumber = registrationNumber();
        }

        $data = $request->only([
            'name',
            'father_name',
            'mother_name',
            'village',
            'police_station',
            'block',
            'district_id',
            'state_id',
            'mobile_number',
            'email',
            'educational_qualifications',
            'date',
            'date_of_birth',
            'postal_code',
        ]);
        $data['reg_no'] = $registrationNumber;
        $data['added_by'] = 'web';

        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('Registration/photos', 'public');
        }

        if ($request->hasFile('signature')) {
            $data['signature'] = $request->file('signature')->store('Registration/signatures', 'public');
        }

        $registration =   Registration::create($data);
        return view('admin.registrations.print', compact('registration'));
        // return redirect()->route('registration.create')->with('success', 'Registered successfully.');
    }
}
