<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\PDCRegistration;
use App\Models\Setting;
use Illuminate\Http\Request;

class PDCRegistrationController extends Controller
{
    public function __construct()
    {
        $pdcrBit = Setting::first('front_pdcr_bit');
        if (!$pdcrBit || $pdcrBit->front_pdcr_bit == 0) {
            abort(404);
        }
    }
    public function register()
    {
        return view('front.pdc.register');
    }

    public function storeRegistration(Request $request)
    {
        if ($request->has('mobile_number')) {
            $request->merge([
                'mobile_number' => preg_replace('/\s+/', ' ', trim($request->input('mobile_number')))
            ]);
        }
        // return $request;
        $request->validate([
            'name' => 'required|string|max:255',
            'father_name' => 'required|string|max:255',
            'mother_name' => 'required|string|max:255',
            'village' => 'required|string|max:255',
            'police_station' => 'required|string|max:255',
            'block' => 'required|string|max:255',
            'district_id' => 'required|exists:districts,id',
            'state_id' => 'required|exists:states,id',
            'mobile_number' => [
                'required',
                'string',
                'regex:/^\+91\s\d{5}\s\d{5}$/',
                'unique:pdc_registrations',
            ],
            // 'mobile_number' => 'required|string|max:255|unique:pdc_registrations',
            'email' => 'required|email|unique:pdc_registrations|string|max:255',
            'educational_qualifications' => 'required|string|max:255',
            'photo' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'signature' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'date' => 'nullable|date',
            'date_of_birth' => 'required|date',
            'postal_code' => 'nullable|numeric',
            'adhar_card_front' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'adhar_card_back' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // $mobile_number = str_replace(['-', '_'], '', $request->input('mobile_number'));
        $mobile_number = $request->input('mobile_number');
        $registrationNumber = registrationNumber();
        while (PDCRegistration::where('reg_no', $registrationNumber)->exists()) {
            $registrationNumber = registrationNumber();
        }

        $data = $request->only([
            'name',
            'father_name',
            'mother_name',
            'village',
            'police_station',
            'block',
            'district_id',
            'state_id',
            'mobile_number',
            'email',
            'educational_qualifications',
            'date',
            'date_of_birth',
            'postal_code',

        ]);
        $data['user_id'] = auth()->user()->id;
        $data['reg_no'] = $registrationNumber;
        $data['added_by'] = 'web';


        if ($request->hasFile('photo')) {
            $data['photo'] = $request->file('photo')->store('PDC_Registration/photos', 'public');
        }

        if ($request->hasFile('signature')) {
            $data['signature'] = $request->file('signature')->store('PDC_Registration/signatures', 'public');
        }
        if ($request->hasFile('adhar_card_back')) {
            $originalName = pathinfo($request->file('adhar_card_back')->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $request->file('adhar_card_back')->getClientOriginalExtension();
            $customName = $originalName . '_back.' . $extension;
            $data['adhar_card_back'] = $request->file('adhar_card_back')->storeAs('PDC_Registration/adhar_card', $customName, 'public');
        }
        if ($request->hasFile('adhar_card_front')) {
            $originalName = pathinfo($request->file('adhar_card_front')->getClientOriginalName(), PATHINFO_FILENAME);
            $extension = $request->file('adhar_card_front')->getClientOriginalExtension();
            $customName = $originalName . '_front.' . $extension;
            $data['adhar_card_front'] = $request->file('adhar_card_front')->storeAs('PDC_Registration/adhar_card', $customName, 'public');
        }

        $registration =   PDCRegistration::create($data);
        return view('admin.pdcr.print', compact('registration'));

        // return redirect()->route('pdcr.index')->with('success', 'PDC Registration created successfully.');
    }
}
