<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LockScreenController extends Controller
{
    public function showLockScreen()
    {
        return view('auth.lockScreen');
    }
    public function unlock(Request $request)
    {
        $request->validate([
            'password' => 'required',
        ]);

        if (Auth::attempt(['email' => Auth::user()->email, 'password' => $request->password])) {
            $request->session()->forget('locked');
            return redirect()->intended('/dashboard');
        }

        return back()->withErrors(['password' => 'Incorrect password']);
    }

    public function lock(Request $request)
    {
        $request->session()->put('locked', true);
        return redirect()->route('lockscreen');
    }
}
