<?php

namespace App\Http\Controllers\Admin;

use App\DataTables\BSSSharedFileDataTable;
use App\Http\Controllers\Controller;
use App\Models\BSSSharedFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class SharedFileController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(BSSSharedFileDataTable $datatable)
    {
        return $datatable->render('admin.sharedfile.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $bsssharedfile = BSSSharedFile::findOrFail($id);
        return view('admin.sharedfile.edit',compact('bsssharedfile'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'file_name' => 'required|string|max:255',
            'visibility' => 'required|string',
            'cropped_image' => 'nullable|string', // Base64 image string
        ]);

        $bssSharedFile = BSSSharedFile::findOrFail($id);

        $croppedImagePath = $bssSharedFile->file_path;
        $imageType = $bssSharedFile->file_type;
        $imageSize = $bssSharedFile->file_size;

        if ($request->has('cropped_image') && $request->input('cropped_image') !== '') {
            $croppedImageBase64 = $request->input('cropped_image');
            if (preg_match('/^data:image\/(\w+);base64,/', $croppedImageBase64, $matches)) {
                $croppedImageBase64 = substr($croppedImageBase64, strpos($croppedImageBase64, ',') + 1);
            }
            $croppedImageData = base64_decode($croppedImageBase64);

            if ($croppedImageData === false) {
                return redirect()->back()->with('error', 'Failed to decode image.');
            }
            $croppedImagePath = $request->input('file_name') . time() . '.' . $imageType;
            $stored = Storage::disk('SharedFiles')->put($croppedImagePath, $croppedImageData);
            if (!$stored) {
                return redirect()->route('bss.shared.files')->with('error', 'Failed to save cropped image.');
            }
            if (Storage::disk('SharedFiles')->exists($bssSharedFile->file_path)) {
                Storage::disk('SharedFiles')->delete($bssSharedFile->file_path);
            }
            $imageType = pathinfo($croppedImagePath, PATHINFO_EXTENSION);
            $imageSize = strlen($croppedImageData);
        }
        $bssSharedFile->update([
            'name' => $request->input('file_name'),
            'file_path' => $croppedImagePath,
            'file_type' => $imageType,
            'file_size' => $imageSize,
            'visibility' => $request->input('visibility'),
        ]);

        return redirect()->route('shared.files.index')->with('success', 'File updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $sharedFile = BSSSharedFile::findOrFail($id);
        if ($sharedFile->file_path && Storage::disk('SharedFiles')->exists($sharedFile->file_path)) {
        Storage::disk('SharedFiles')->delete($sharedFile->file_path);
        }
        $sharedFile->delete();
        return response()->json(['success' => 'File deleted successfully.']);
    }
}
