<?php

namespace App\Http\Controllers\Admin;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SettingController extends Controller
{
    public function generalSettings()
    {
        $settings = Setting::first();
        return view('admin.settings.general.index', compact('settings'));
    }

    public function storegeneralSettings(Request $request)
    {
        // Validate the request data
        $request->validate([
            'prefix_suffix' => 'required',
            'prefix_suffix_bit' => 'required',
            'front_pdcr_bit' => 'required',
        ]);

        // Retrieve the first setting record or create a new one if none exists
        $setting = Setting::first();

        // Update or create the settings record
        Setting::updateOrCreate(
            ['id' => $setting ? $setting->id : null],
            [
                'prefix_suffix' => $request->prefix_suffix,
                'prefix_suffix_bit' => $request->prefix_suffix_bit,
                'front_pdcr_bit' => $request->front_pdcr_bit ?? 0,
            ]
        );

        // Redirect back with a success message
        return redirect()->route('settings.generalsettings')->with('success', 'Settings saved successfully.');
    }
}
