<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\District;
use App\Models\Country;
use App\Models\State;
use Illuminate\Http\Request;

class GeneralController extends Controller
{
    public function CountriesSearch()
    {
        if (request()->filled('q')) {
            $keyword = request()->get('q');
            return Country::select('id', 'name')
                ->where("name", "LIKE", "%$keyword%")
                ->orWhere('country_code', "LIKE", "%$keyword%")
                ->orWhere('capital', "LIKE", "%$keyword%")
                ->orderBy('name')
                ->get();
        } else {
            $data = Country::orderBy('name')->take(10)->get();
        }
        return response()->json($data);
    }

    public function IndiaStateSearch()
    {
        // $india_id = Country::where('name', 'India')->first()->id;
        // if (request()->filled('q')) {
        //     $keyword = request()->get('q');
        //     return State::where('country_id', $india_id)->select('id', 'name')
        //         ->where("name", "LIKE", "%$keyword%")
        //         ->orderBy('name')
        //         ->get();
        // } else {
        //     $data = State::orderBy('name')->take(10)->get();
        // }
        $data = State::where(function ($query) {
            $query->where('name', 'LIKE', 'Bihar')
                ->orWhere('name', 'LIKE', 'बिहार');
        })->get();
        return response()->json($data);
    }

    public function StateDestrictsSearch()
    {
        if (request()->filled('c')) {
            $state_id = request('c');
            if (request()->filled('q')) {
                $keyword = request()->get('q');
                return District::select('id', 'name','name_hindi')
                    ->where('state_id', $state_id)
                    ->where("name", "LIKE", "%$keyword%")
                    ->orderBy('name')
                    ->get();
            } else {
                return District::select('id', 'name','name_hindi')
                    ->where('state_id', $state_id)
                    ->orderBy('name')
                    ->get();
            }
        } else {
            $data = District::orderBy('name')->get();
        }
        return response()->json($data);
    }
}
