<?php

namespace App\Http\Controllers\Admin\Bss;

use App\Models\BssStudent;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\BSSStudentAttendance;
use App\Models\BSSTeacher;
use Illuminate\Support\Facades\Auth;

class BSSStudentAttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // $students = BssStudent::where('bss_id', Auth::id())->get();
        // return $students;

        $students = BssStudent::where('bss_id', Auth::id())
            ->with(['student_attandances' => function ($query) {
                $query->whereDate('created_at', now());
            }])
            ->get();
        return view('admin.bss.student.attendence.create', compact('students'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // return $request;
        $data = $request->all();
        $today = now()->toDateString();  // Get today's date in `Y-m-d` format

        foreach ($data['student_id'] as $studentId) {
            // Check if the attendance record already exists for today
            $attendance = BSSStudentAttendance::where('bss_student_id', $studentId)
                ->whereDate('created_at', $today)
                ->first();

            if (empty($data['review'][$studentId]) && empty($data['attendance'][$studentId])) {
                continue;
            }
            if (empty($data['attendance'][$studentId])) {
                return redirect()->route('bss.students.attendence')->with('warning', 'Attendence field is required');
            }
            $attendanceData = [
                'bss_student_id' => $studentId,
                'attendance_status' => $data['attendance'][$studentId],
                'review' => $data['review'][$studentId],
                'created_at' => now(),
                'updated_at' => now(),
            ];

            // If record exists, update it, else create a new one
            if ($attendance) {
                $attendance->update($attendanceData);  // Update existing record
            } else {
                BSSStudentAttendance::create($attendanceData);  // Create new record
            }
        }

        return redirect()->route('bss.students.attendence')->with('success', 'Attendance saved successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function generatestudentReport(Request $request, $id)
    {

        $student = BssStudent::findOrFail($id);
        $attendancesQuery = $student->student_attandances();

        if ($request->has('date_from') || $request->has('date_to') || $request->has('search')) {
            $dateFrom = $request->input('date_from');
            $dateTo = $request->input('date_to');

            if ($dateFrom) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '>=', $dateFrom);
            }

            if ($dateTo) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '<=', $dateTo);
            }

            if ($request->has('search')) {
                $attendancesQuery = $attendancesQuery->where('attendance_status', 'like', '%' . $request->input('search') . '%');
            }
        }

        $attendances = $attendancesQuery->orderBy('created_at', 'desc')->paginate(1);

        return view('admin.bss.student.attendence.report', compact('student', 'attendances', 'request'));
    }

    public function generateAllstudentReport(Request $request)
    {
        // return $request;
        $user = Auth::user();
        if ($user->hasRole('bss_admin'))
            $students = BssStudent::with(['student_attandances' => function ($query) use ($request) {
                if ($request->has('date_from') && $request->input('date_from') !== null) {
                    $query->whereDate('created_at', '>=', $request->input('date_from'));
                }

                if ($request->has('date_to') && $request->input('date_to') !== null) {
                    $query->whereDate('created_at', '<=', $request->input('date_to'));
                }

                if ($request->has('search')) {
                    $query->where('attendance_status', 'like', '%' . $request->input('search') . '%');
                }
            }])->where('bss_id', $user->id)->get();
        else {
            $students = BssStudent::with(['student_attandances' => function ($query) use ($request) {
                // Apply filters to the teacher_attandances relationship
                if ($request->has('date_from') && $request->input('date_from') !== null) {
                    $query->whereDate('created_at', '>=', $request->input('date_from'));
                }

                if ($request->has('date_to') && $request->input('date_to') !== null) {
                    $query->whereDate('created_at', '<=', $request->input('date_to'));
                }

                if ($request->has('search')) {
                    $query->where('attendance_status', 'like', '%' . $request->input('search') . '%');
                }
            }])->get();
        }
        // Collect all the attendances
        $attendances = $students->flatMap(function ($student) {
            return $student->student_attandances;
        });

        // Paginate the results manually
        $perPage = 20;
        $page = $request->input('page', 1);
        $paginatedAttendances = new \Illuminate\Pagination\LengthAwarePaginator(
            $attendances->forPage($page, $perPage),
            $attendances->count(),
            $perPage,
            $page,
            ['path' => $request->url(), 'query' => $request->query()]
        );

        return view('admin.bss.student.attendence.all_student_report', [
            'attendances' => $paginatedAttendances,
            'request' => $request,
        ]);
    }

    public function exportCSV($id, Request $request)
    {
        $student = BssStudent::findOrFail($id);
        $attendancesQuery = $student->student_attandances();

        // Filter logic based on the request
        if ($request->has('date_from') || $request->has('date_to') || $request->has('search')) {
            $dateFrom = $request->input('date_from');
            $dateTo = $request->input('date_to');

            // Apply date filters
            if ($dateFrom) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '>=', $dateFrom);
            }

            if ($dateTo) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '<=', $dateTo);
            }

            // Apply search filter for attendance status
            if ($request->has('search')) {
                $attendancesQuery = $attendancesQuery->where('attendance_status', 'like', '%' . $request->input('search') . '%');
            }
        }

        // Prepare the filename
        $filename = 'BSS_Student_Attendance_Report_' . date('Y-m-d') . '.csv';
        $handle = fopen('php://output', 'w');

        // Clean the output buffer if needed
        if (ob_get_level() > 0) {
            ob_end_clean();
        }

        // Set headers for CSV download
        header('Content-Type: text/csv; charset=UTF-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');

        // Add BOM to handle UTF-8 encoding in Excel
        fprintf($handle, chr(0xEF) . chr(0xBB) . chr(0xBF));

        // Output column headers
        fputcsv($handle, [
            'Student Name',
            'Attendance Status',
            'Review',
            'Date',
            'Day',
        ]);

        // Fetch filtered attendance records (or all records if no filters)
        $attendances = $attendancesQuery->orderBy('created_at', 'desc')->get();

        // Write the records to the CSV
        foreach ($attendances as $attendance) {
            fputcsv($handle, [
                $attendance->student->name,
                $attendance->attendance_status,
                $attendance->review,
                $attendance->created_at->format('Y-m-d'),
                $attendance->created_at->format('l'),
            ]);
        }

        // Close the file handler and exit
        fclose($handle);
        exit();
    }

    public function exportCSVReport(Request $request)
    {
        $attendancesQuery = BSSStudentAttendance::query();

        // Apply filters based on the request
        if ($request->has('date_from') || $request->has('date_to') || $request->has('search')) {
            $dateFrom = $request->input('date_from');
            $dateTo = $request->input('date_to');

            if ($dateFrom) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '>=', $dateFrom);
            }

            if ($dateTo) {
                $attendancesQuery = $attendancesQuery->whereDate('created_at', '<=', $dateTo);
            }

            if ($request->has('search')) {
                $attendancesQuery = $attendancesQuery->where('attendance_status', 'like', '%' . $request->input('search') . '%');
            }
        }

        // Fetch all records matching the query
        $attendances = $attendancesQuery->orderBy('created_at', 'desc')->get();

        // Prepare the filename
        $filename = 'BSS_All_Student_Attendance_Report_' . date('Y-m-d') . '.csv';

        // Open output stream for writing
        $handle = fopen('php://output', 'w');

        if (ob_get_level() > 0) {
            ob_end_clean(); // Clear output buffer if needed
        }

        // Set headers for CSV download
        header('Content-Type: text/csv; charset=UTF-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');

        // Add BOM for UTF-8 compatibility in Excel
        fprintf($handle, chr(0xEF) . chr(0xBB) . chr(0xBF));

        // Write the CSV headers
        fputcsv($handle, [
            'Student Name',
            'Attendance Status',
            'Review',
            'Date',
            'Day',
        ]);

        // Write the attendance data
        foreach ($attendances as $attendance) {
            fputcsv($handle, [
                $attendance->student->name ?? 'N/A', // Handle null teacher name
                $attendance->attendance_status,
                $attendance->review,
                $attendance->created_at->format('Y-m-d'),
                $attendance->created_at->format('l'),
            ]);
        }

        // Close the file handler and exit
        fclose($handle);
        exit();
    }
}
