<?php

use Spatie\Permission\Models\Permission;

if (!function_exists('getPermissions')) {
    function getPermissions()
    {
        return $modules = [
            'Dashboard' => [
                'view_dashboard' => 'View Dashboard',
                'export_pdc_dashboard' => 'Export Dashboard PDC Records',
            ],
            'Registrar' => [
                'view_registrations' => 'View Registration',
                'add_registrations' => 'Add Registration',
                'edit_registrations' => 'Edit Registration',
                'delete_registrations' => 'Delete Registration',
                'import_registrations' => 'Import Registration',
                'export_registrations' => 'Export Registration',
                'print_registrations' => 'Print Registration',
            ],
            'PDC Registrar' => [
                'view_pdc_registration' => 'View PDC Registration',
                'add_pdc_registration' => 'Add PDC Registration',
                'edit_pdc_registration' => 'Edit PDC Registration',
                'delete_pdc_registration' => 'Delete PDC Registration',
                'generate_pdc_certificate' => 'Generate PDC certificate',
                'view_pdc_registration_certificate' => 'View PDC certificate',
                'import_pdc_registration' => 'Import PDC Registration',
                'export_pdc_registration' => 'Export PDC Registration',
                'print_pdc_registration' => 'Print PDC Registration',

            ],

            'Users' => [
                'view_users' => 'View User',
                'add_users' => 'Add User',
                'edit_users' => 'Edit User',
                'delete_users' => 'Delete User',
            ],
            'Settings' => [
                'manage_general_settings' => 'Manage General Settings',
            ],

            'BSS Manager' => [
                'view_bss' => 'View BSS',
                'add_bss' => 'Add BSS',
                'edit_bss' => 'Edit BSS',
                'delete_bss' => 'Delete BSS',
            ],

            'BSS Teachers' => [
                'view_bss_teachers' => 'View BSS Teachers',
                'edit_bss_teachers' => 'Edit BSS Teachers',
                'delete_bss_teachers' => 'Delete BSS Teachers',
                'view_bss_teacher_attendences' => 'View BSS Teacher Attendence',
                'manage_bss_teachers_attendence' => 'Manage BSS Teachers Attendence',
                'bss_teachers_attendence_report' => 'BSS Teachers Attendence Report',
            ],

            'BSS Students' => [
                'view_bss_students' => 'View BSS Students',
                'edit_bss_students' => 'Edit BSS Students',
                'delete_bss_students' => 'Delete BSS Students',
                'view_bss_student_attendences' => 'View BSS Student Attendence',
                'manage_bss_student_attendence' => 'Manage BSS Student Attendence',
                'bss_student_attendence_report' => 'BSS Student Attendence Report',
            ],

            'Files Manager' => [
                'view_files' => 'View Files',
                'delete_files' => 'Delete Files',
            ],


        ];
    }
}
if (!function_exists('checkPermissions')) {
    function checkPermissions($permission)
    {
        $permission = Permission::where('name', $permission)->first();
        if ($permission) {
            return true;
        }
        return false;
    }
}
