<?php

use Carbon\Carbon;

function registrationNumber($count = null)
{
    $count = $count ?? 10;
    $min = (int) str_pad('1', $count, '0', STR_PAD_RIGHT);  // Smallest number with $count digits
    $max = (int) str_pad('', $count, '9', STR_PAD_RIGHT);   // Largest number with $count digits

    $number = mt_rand($min, $max);

    return strval($number);
}


function parseDate($dateString)
{
    // Define a list of possible date formats
    $formats = [
        'd-m-Y',    // dd-mm-yyyy
        'Y-d-m',    // yyyy-dd-mm
        'd/m/Y',    // dd/mm/yyyy
        'Y/m/d',    // yyyy/mm/dd
        'm-d-Y',    // mm-dd-yyyy
        'm/d/Y',    // mm/dd/yyyy
        'Y-m-d'     // yyyy-mm-dd (MySQL default)
    ];

    // Try parsing the date with each format
    foreach ($formats as $format) {
        try {
            $date = Carbon::createFromFormat($format, $dateString);
            if ($date && $date->format($format) === $dateString) {
                return $date->format('Y-m-d'); // Return the date in YYYY-MM-DD format
            }
        } catch (\Exception $e) {
            // Continue if the date doesn't match the current format
            continue;
        }
    }

    // Return false if no valid format was found
    return false;
}
